/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.Print;
import com.mhdt.io.FileIO;
import com.mhdt.log.ExceptionPrintStream;
import com.mhdt.log.Log;
import com.mhdt.log.LogManager;
import com.mhdt.log.LogOut;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.StringUtility;

abstract class AbstractLog
implements Log,
LogOut {
    boolean debugEnable = true;
    Log.Level level = LogManager.getGlobalLevel();
    long lastTime;

    public AbstractLog() {
        ExceptionPrintStream.addLogOut(this);
    }

    @Override
    public boolean isDebugEnable() {
        return this.level.intValue() >= Log.Level.DEBUG.intValue();
    }

    @Override
    public Log.Level getLevel() {
        return this.level;
    }

    protected String generatingOutput(Log.Level level, String methodName, Object message, Throwable throwable) {
        String[] identifier = Log.identifier.get((Object)level);
        return identifier[0] + level.sign + identifier[1] + "\t" + DateUtility.getNow("HH:mm:ss") + " " + Print.getCodeInfo(4) + "\t- " + (message == null ? "\tnull" : message.toString()) + " " + StringUtility.getStackMessage(throwable);
    }

    protected void outputLog(Log.Level level, String outMessage) {
        FileIO.write(this.getLogFile(), "\r\n" + outMessage, true);
    }

    @Override
    public void info(Object obj) {
        if (this.level.intValue >= Log.Level.INFO.intValue) {
            String outMessage = this.generatingOutput(Log.Level.INFO, this.getMethod(), String.valueOf(obj), null);
            System.err.println(outMessage);
        }
    }

    protected String getMethod() {
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        String method = "unknown";
        if (locations != null && locations.length > 3) {
            StackTraceElement caller = locations[3];
            method = caller.getMethodName();
        }
        return method;
    }

    @Override
    public void warn(Object obj) {
        if (this.level.intValue >= Log.Level.WARN.intValue) {
            String outMessage = this.generatingOutput(Log.Level.WARN, this.getMethod(), String.valueOf(obj), null);
            System.err.println(outMessage);
        }
    }

    @Override
    public void debug(Object obj) {
        if (this.level.intValue >= Log.Level.DEBUG.intValue) {
            String outMessage = this.generatingOutput(Log.Level.DEBUG, this.getMethod(), String.valueOf(obj), null);
            System.err.println(outMessage);
        }
    }

    @Override
    public void debug(Object obj, Throwable ex) {
        if (this.level.intValue >= Log.Level.DEBUG.intValue) {
            String outMessage = this.generatingOutput(Log.Level.DEBUG, this.getMethod(), String.valueOf(obj), ex);
            System.err.println(outMessage);
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.level.intValue >= Log.Level.OFF.intValue) {
            String outMessage = this.generatingOutput(Log.Level.DEBUG, this.getMethod(), String.valueOf(""), e);
            System.err.println(outMessage);
        }
    }

    @Override
    public void error(Object obj) {
        if (this.level.intValue >= Log.Level.OFF.intValue) {
            String outMessage = this.generatingOutput(Log.Level.DEBUG, this.getMethod(), String.valueOf(obj), null);
            System.err.println(outMessage);
        }
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(long timelong) {
        this.lastTime = timelong;
    }

    static {
        System.setErr(ExceptionPrintStream.getInstance());
    }
}

