/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.ui;

import com.mhdt.system.WindowClosing;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;

public class Window
extends JFrame
implements WindowListener {
    private AtomicBoolean minimize = new AtomicBoolean();
    private static final long serialVersionUID = 9172229125891839930L;

    public Window() {
        this.setTitle("mhdt.com");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public Window(int width, int height) {
        this.setTitle("mhdt.com");
        this.setDefaultCloseOperation(0);
        this.setSize(width, height);
        this.addWindowListener(this);
    }

    public Window(String title) {
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public Window(String title, int width, int height) {
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setSize(width, height);
    }

    public final void setCenterInDesktop() {
        if (this.getWidth() < 1 || this.getHeight() < 1) {
            return;
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 3);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.setSize(preferredSize);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window c = (Window)e.getComponent();
        if (c.getContentPane() instanceof WindowClosing) {
            WindowClosing action = (WindowClosing)((Object)c.getContentPane());
            action.onWindowClosing();
        } else {
            System.out.println("\u7a0b\u5e8f\u5df2\u5173\u95ed\uff01");
            System.exit(0);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.minimize.compareAndSet(true, false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.minimize.compareAndSet(false, true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public boolean isMinimize() {
        return this.minimize.get();
    }

    public void response() {
        if (this.isMinimize()) {
            this.requestFocus();
        }
    }
}

