/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.toolkit.SimpleRandom;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class AuthcodeUtil {
    SimpleRandom random = new SimpleRandom();

    public BufferedImage createAuthcode(String content, int width, int height, Color foreColor, Color backgroundColor, boolean isDrawInterferLine, boolean isDrawNoise) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        this.renderHint(g2d);
        this.drawBackground(g2d, backgroundColor, width, height);
        if (isDrawInterferLine) {
            this.drawInterferingLine(g2d, width, height);
        }
        if (isDrawNoise) {
            this.drawNoise(bufferedImage);
        }
        this.drawStr(content, width, height, g2d, foreColor);
        return bufferedImage;
    }

    private void renderHint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void drawBackground(Graphics2D g2d, Color backgroundColor, int width, int height) {
        g2d.setColor(backgroundColor == null ? new Color(237, 246, 255) : backgroundColor);
        g2d.fillRect(0, 0, width, height);
    }

    private void drawStr(String str, int width, int height, Graphics2D g2d, Color foreColor) {
        g2d.setColor(foreColor == null ? new Color(83, 134, 139) : foreColor);
        int fontSize = height - 4;
        Font font = new Font("Algerian", 0, fontSize);
        g2d.setFont(font);
        char[] chars = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * this.random.nextDouble() * (double)(this.random.nextBoolean() ? 1 : -1), width / str.length() * i + fontSize / 2, height / 2);
            g2d.setTransform(affine);
            g2d.drawChars(chars, i, 1, (width - 10) / str.length() * i + 5, height / 2 + fontSize / 3);
        }
        g2d.dispose();
    }

    private void drawInterferingLine(Graphics2D g2d, int width, int height) {
        for (int i = 0; i < height / 4; ++i) {
            int x = this.random.nextInt(width - 1);
            int y = this.random.nextInt(height - 1);
            int xl = this.random.nextInt(width / 2) + 1;
            int yl = y + this.random.nextInt(height / 3) + 1;
            g2d.setColor(this.random.nextColor());
            g2d.drawLine(x, y, x + xl + 40, yl);
        }
    }

    private void drawNoise(BufferedImage bufferedImage) {
        float yawpRate = 0.03f;
        int area = (int)(yawpRate * (float)bufferedImage.getWidth() * (float)bufferedImage.getHeight());
        for (int i = 0; i < area; ++i) {
            int x = this.random.nextInt(bufferedImage.getWidth());
            int y = this.random.nextInt(bufferedImage.getHeight());
            int rgb = this.random.nextColor().getRGB();
            bufferedImage.setRGB(x, y, rgb);
        }
    }
}

