/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.parse;

import com.mhdt.Print;
import com.mhdt.io.FileIO;
import com.mhdt.parse.GetWord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Forest {
    Map<String, GetWord> map;

    public Forest(InputStream in) {
        String s = FileIO.getContent(in);
        this.init(s);
    }

    public Forest(File file) {
        if (!file.exists()) {
            Print.info(file.getAbsolutePath());
        }
        String s = FileIO.getContent(file);
        this.init(s);
    }

    public Forest(String path) throws FileNotFoundException {
        String s = FileIO.getContent(path);
        this.init(s);
    }

    private void init(String content) {
        String[] rows;
        this.map = new HashMap<String, GetWord>();
        for (String temp : rows = content.split("\r\n")) {
            GetWord word = new GetWord();
            String[] params = temp.split("\\s");
            if (params.length > 0) {
                word.setName(params[0]);
            } else {
                word = null;
            }
            if (params.length > 1) {
                for (int i = 1; i < params.length; ++i) {
                    String param = params[i];
                    word.addParam(param);
                }
            }
            if (word == null) continue;
            this.map.put(word.getName(), word);
        }
    }

    public List<GetWord> contains(String content) {
        ArrayList<GetWord> result = new ArrayList<GetWord>();
        for (Map.Entry<String, GetWord> entry : this.map.entrySet()) {
            if (content.indexOf(entry.getKey()) == -1) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public GetWord get(int index) {
        return this.map.get(String.valueOf(index));
    }

    public GetWord get(String name) {
        return this.map.get(name);
    }

    public Collection<GetWord> getAll() {
        return this.map.values();
    }

    public synchronized void add(GetWord word) {
        this.map.put(word.getName(), word);
    }

    public synchronized void addAll(Collection<GetWord> list) {
        for (GetWord word : list) {
            this.add(word);
        }
    }

    public synchronized void remove(String key) {
        this.map.remove(key);
    }

    public void save(File desc) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, GetWord> entry : this.map.entrySet()) {
            sb.append(entry.getKey() + " ");
            for (String param : entry.getValue().getParams()) {
                sb.append(param + " ");
            }
            sb.append("\r\n");
        }
        FileIO.write(desc, sb.toString(), false);
    }

    public String toString() {
        return "Forest [" + this.map.values() + "]";
    }
}

