/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.log.DefaultLog;
import com.mhdt.log.IndependentLog;
import com.mhdt.toolkit.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public interface Log {
    public static final Map<Level, String[]> identifier = new HashMap<Level, String[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Level.INFO, new String[]{"[", "]"});
            this.put(Level.WARN, new String[]{"\u2606", "\u2606"});
            this.put(Level.DEBUG, new String[]{"[", "]"});
            this.put(Level.ERROR, new String[]{"\u300c", "\u300d"});
        }
    };
    public static final String DEFAULTOUTPATH = PathUtil.underCurrentProject() + File.separator + "log" + File.separator;
    public static final Map<String, Log> cache = new HashMap<String, Log>();

    public boolean isDebugEnable();

    public Level getLevel();

    public void setLevel(Level var1);

    public void info(String var1);

    public void error(Throwable var1);

    public void error(String var1);

    public void debug(String var1);

    public void warn(String var1);

    public static Log getDefaultLog() {
        return DefaultLog.getInstance();
    }

    public static Log getIndependentLog(String namespace) {
        if (cache.containsKey(namespace)) {
            return cache.get(namespace);
        }
        return new IndependentLog(namespace);
    }

    public static Log getIndependentLog(String namespace, File outputFolder) {
        return new IndependentLog(namespace, outputFolder);
    }

    public static enum Level {
        INFO("green"),
        WARN("yellow"),
        ERROR("red"),
        DEBUG("pink");

        String color;

        private Level(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }
}

