/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.Print;
import com.mhdt.analyse.Validate;
import com.mhdt.log.AbstractLog;
import com.mhdt.log.Log;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.FileUtility;
import java.io.File;

public class IndependentLog
extends AbstractLog {
    String namespace;
    File outputFolder = new File(Log.DEFAULTOUTPATH);

    public IndependentLog(String namespace) {
        this.namespace = namespace;
    }

    @Override
    protected String generatingOutput(Log.Level level, Object message) {
        String[] identifier = Log.identifier.get((Object)level);
        return identifier[0] + level.toString() + identifier[1] + "\t" + DateUtility.getNow("HH:mm:ss") + " " + Print.getCodeInfo(4) + " - " + this.namespace + " " + (message == null ? "\tnull" : message.toString());
    }

    public IndependentLog(String namespace, File outputFolder) {
        if (outputFolder == null) {
            throw new NullPointerException("\u8f93\u51fa\u6587\u4ef6\u5939\u4e3anull");
        }
        if (Validate.isNullOrEmpty(namespace)) {
            throw new NullPointerException("\u547d\u540d\u7a7a\u95f4\u4e3a\u7a7a");
        }
        if (!outputFolder.exists()) {
            FileUtility.createFloder(outputFolder);
        }
        this.namespace = namespace;
    }

    @Override
    public File getLogFile() {
        File file = FileUtility.join(this.outputFolder, DateUtility.today() + "-" + this.namespace + ".txt");
        if (!file.exists()) {
            FileUtility.createFile(file);
        }
        return file;
    }

    @Override
    public File getErrorFile() {
        File file = FileUtility.join(this.outputFolder, DateUtility.today() + "-error.txt");
        if (!file.exists()) {
            FileUtility.createFile(file);
        }
        return file;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }
}

