/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.Print;
import com.mhdt.io.FileIO;
import com.mhdt.log.ExceptionPrintStream;
import com.mhdt.log.Log;
import com.mhdt.log.LogOut;
import com.mhdt.toolkit.DateUtility;

abstract class AbstractLog
implements Log,
LogOut {
    boolean debugEnable = true;
    Log.Level level;
    long lastTime;

    public AbstractLog() {
        ExceptionPrintStream.addLogOut(this);
    }

    @Override
    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    @Override
    public Log.Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Log.Level level) {
        this.level = level;
        if (level == Log.Level.DEBUG) {
            this.debugEnable = true;
        }
    }

    protected String generatingOutput(Log.Level level, Object message) {
        String[] identifier = Log.identifier.get((Object)level);
        return identifier[0] + level.toString() + identifier[1] + "\t" + DateUtility.getNow("HH:mm:ss") + " " + Print.getCodeInfo(4) + "\t- " + (message == null ? "\tnull" : message.toString());
    }

    protected void outputLog(Log.Level level, String outMessage) {
        FileIO.write(this.getLogFile(), "\r\n" + outMessage, true);
    }

    @Override
    public void info(String message) {
        String outMessage = this.generatingOutput(Log.Level.INFO, message);
        System.out.println(outMessage);
        this.outputLog(Log.Level.INFO, outMessage);
    }

    @Override
    public void warn(String message) {
        String outMessage = this.generatingOutput(Log.Level.WARN, message);
        System.out.println(outMessage);
        this.outputLog(Log.Level.WARN, outMessage);
    }

    @Override
    public void debug(String message) {
        String outMessage = this.generatingOutput(Log.Level.DEBUG, message);
        System.out.println(outMessage);
        this.outputLog(Log.Level.DEBUG, outMessage);
    }

    @Override
    public void error(Throwable e) {
        e.printStackTrace();
    }

    @Override
    public void error(String message) {
        System.out.println(Print.getCodeInfo(3) + " -\t" + message);
        this.outputLog(Log.Level.ERROR, this.generatingOutput(Log.Level.ERROR, message));
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(long timelong) {
        this.lastTime = timelong;
    }

    static {
        System.setErr(ExceptionPrintStream.getInstance());
    }
}

