/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.io;

import com.mhdt.analyse.Validate;
import com.mhdt.exception.imageTransformException;
import com.mhdt.toolkit.FileUtility;
import com.mhdt.toolkit.ImageUtility;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IMGIO {
    public static final BufferedImage load(InputStream in) {
        try {
            return ImageIO.read(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final BufferedImage load(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return IMGIO.load(in);
    }

    public static final BufferedImage load(Class<?> cls, String path) {
        try {
            return ImageIO.read(cls.getResource(path));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final BufferedImage load(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        return IMGIO.load(fis);
    }

    public static final ImageIcon load(String path) {
        return new ImageIcon(path);
    }

    public static final boolean save(Image image, File outFile) {
        FileUtility.createFile(outFile);
        String format = FileUtility.getFormat(outFile);
        int type = 0;
        if (!Validate.isNullOrEmpty(format) && format.equals("png")) {
            type = 2;
        } else {
            format = "jpg";
            type = 8;
        }
        try {
            return IMGIO.save(image, format, outFile, type);
        }
        catch (imageTransformException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean save(Image image, String format, File outFile) {
        int type = 0;
        type = format.equals("png") ? 2 : 8;
        try {
            return IMGIO.save(image, format, outFile, type);
        }
        catch (imageTransformException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean save(Image image, File outFile, int bufferedType) {
        try {
            return IMGIO.save(image, FileUtility.getFormat(outFile), outFile, bufferedType);
        }
        catch (imageTransformException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean save(Image image, String format, File outFile, int bufferedType) throws imageTransformException {
        try {
            FileUtility.createFile(outFile);
            BufferedImage bf = null;
            try {
                bf = ImageUtility.imageToBufferedImage(image, bufferedType);
            }
            catch (imageTransformException e) {
                e.printStackTrace();
                return false;
            }
            ImageIO.write((RenderedImage)bf, format, outFile);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final void save(List<BufferedImage> list, File outFloder) {
        FileUtility.createFloder(outFloder);
        for (int i = 0; i < list.size(); ++i) {
            IMGIO.save((Image)list.get(i), "png", new File(outFloder + "/" + System.currentTimeMillis() + ".png"));
        }
    }

    public static final void save(List<BufferedImage> list, String format, File outFolder) {
        FileUtility.createFloder(outFolder);
        for (int i = 0; i < list.size(); ++i) {
            BufferedImage bf = list.get(i);
            if (bf == null) continue;
            IMGIO.save((Image)bf, "png", new File(outFolder + "/" + System.currentTimeMillis() + ".png"));
        }
    }

    public static final void save(List<BufferedImage> list, String format, String fileName, File outerFolder) {
        FileUtility.createFloder(outerFolder);
        for (int i = 0; i < list.size(); ++i) {
            if (Validate.isNullOrEmpty(format)) {
                format = "png";
            }
            IMGIO.save((Image)list.get(i), format, new File(outerFolder + "/" + fileName + ".png"));
        }
    }

    public static final void saveByRows(List<List<BufferedImage>> list, String format, File outFloder) {
        FileUtility.createFloder(outFloder);
        for (int row = 0; row < list.size(); ++row) {
            List<BufferedImage> temp = list.get(row);
            for (int col = 0; col < temp.size(); ++col) {
                if (Validate.isNullOrEmpty(format)) {
                    format = "png";
                }
                IMGIO.save((Image)temp.get(col), format, new File(outFloder + "/" + row + "-" + col + ".png"));
            }
        }
    }

    public static byte[] getBytes(BufferedImage image, String format) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, out);
        return out.toByteArray();
    }
}

