/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.dataStructure.cache;

import com.mhdt.dataStructure.cache.AbstractCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends AbstractCache<K, V> {
    private boolean openExpire = false;

    public LRUCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public LRUCache(int cacheSize, long defaultExpire) {
        super(cacheSize, defaultExpire);
        this.cacheMap = new LinkedHashMap<K, AbstractCache.CacheObject<V>>(cacheSize + 1, 1.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, AbstractCache.CacheObject<V>> eldest) {
                return LRUCache.this.removeEldestEntry(eldest);
            }
        };
    }

    private boolean removeEldestEntry(Map.Entry<K, AbstractCache.CacheObject<V>> eldest) {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.size() > this.cacheSize;
    }

    @Override
    public void put(K key, V value, long survival) {
        if (!this.openExpire && survival > 0L) {
            this.openExpire = true;
        }
        super.put(key, value, survival);
    }

    @Override
    protected int eliminateCache() {
        if (!this.isOpenExpire()) {
            return 0;
        }
        Iterator iterator = this.cacheMap.values().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            AbstractCache.CacheObject cacheObject = (AbstractCache.CacheObject)iterator.next();
            if (!cacheObject.isExpired()) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    private boolean isOpenExpire() {
        return this.defaultExpira > 0L || this.openExpire;
    }
}

