/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.dataStructure.cache;

import com.mhdt.dataStructure.cache.AbstractCache;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FIFOCache<K, V>
extends AbstractCache<K, V> {
    FIFOCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public FIFOCache(int cacheSize, long defaultExpire) {
        super(cacheSize, defaultExpire);
        this.cacheMap = new LinkedHashMap(cacheSize + 1);
    }

    @Override
    protected int eliminateCache() {
        int count = 0;
        Object firstKey = null;
        Iterator iterator = this.cacheMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            AbstractCache.CacheObject cacheObject = (AbstractCache.CacheObject)this.cacheMap.get(key);
            if (cacheObject.isExpired()) {
                iterator.remove();
                ++count;
                continue;
            }
            if (firstKey != null) continue;
            firstKey = key;
        }
        if (firstKey != null && this.isFull()) {
            this.cacheMap.remove(firstKey);
        }
        return count;
    }
}

