/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.analyse;

import com.mhdt.analyse.Counter;
import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.DateUtility;

public class SimpleCounter
implements Counter {
    int originalValue;
    int value;
    Integer last_day;
    int last_increase_time;

    public SimpleCounter(int originalValue) {
        this.originalValue = originalValue;
        this.reset();
    }

    @Override
    public void increaseWithDay() {
        this.increaseWithDay(1);
    }

    @Override
    public void increaseWithDay(int incremental) {
        int now = Integer.parseInt(DateUtility.getNow("dd"));
        if (!Validate.isNullOrEmpty(this.last_day) && now > this.last_day) {
            this.reset();
        } else {
            this.value += incremental;
        }
        this.last_day = now;
        this.last_increase_time = DateUtility.getNowForInt();
    }

    @Override
    public void reset() {
        this.value = this.originalValue;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getLastIncreaseTime() {
        return this.last_increase_time;
    }
}

