/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.analyse;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class FreeMarker {
    Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    StringTemplateLoader stringLoader;

    public void loadStringTemplate(String name, String template) {
        if (this.stringLoader == null) {
            this.stringLoader = new StringTemplateLoader();
            this.configuration.setTemplateLoader((TemplateLoader)this.stringLoader);
        }
        this.stringLoader.putTemplate(name, template);
    }

    public void loadDirectoryTemplate(File directory) throws IOException {
        this.configuration.setDirectoryForTemplateLoading(directory);
    }

    public String out(String templateId, Object args) {
        try {
            Template template = this.configuration.getTemplate(templateId, "utf-8");
            StringWriter writer = new StringWriter();
            template.process(args, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

