/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt;

import com.mhdt.log.Log;
import com.mhdt.toolkit.DateUtility;
import org.fusesource.jansi.Ansi;

public class Print {
    static int lastTime;

    public static void info(Object obj, int stackIndex) {
        System.out.println(Print.getCodeInfo(stackIndex) + (obj == null ? "null" : obj.toString()));
    }

    public static String info(Object obj) {
        String[] identifier = Log.identifier.get((Object)Log.Level.INFO);
        String message = Print.toString(identifier[0] + " INFO " + identifier[1], "CYAN", obj == null ? "null" : obj.toString());
        System.out.println(message);
        return message;
    }

    public static String warn(Object obj) {
        String[] identifier = Log.identifier.get((Object)Log.Level.WARN);
        String message = Print.toString(identifier[0] + " WARN " + identifier[1], "WHITE", obj == null ? "null" : obj.toString());
        System.out.println(message);
        return message;
    }

    public static String debug(Object obj) {
        String[] identifier = Log.identifier.get((Object)Log.Level.DEBUG);
        String message = Print.toString(identifier[0] + " DEBUG " + identifier[1], "BLUE", obj == null ? "null" : obj.toString());
        System.out.println(message);
        return message;
    }

    public static String error(Object obj) {
        String[] identifier = Log.identifier.get((Object)Log.Level.ERROR);
        String message = Print.toString(identifier[0] + " ERROR " + identifier[1], "RED", obj == null ? "null" : obj.toString());
        System.out.println(message);
        return message;
    }

    public static String out(Object obj, String color) {
        String message = Print.translate(color, obj == null ? "null" : obj.toString());
        System.out.println(message);
        return message;
    }

    private static String getTime() {
        if (DateUtility.getNowForInt() - lastTime > 5) {
            lastTime = DateUtility.getNowForInt();
            return DateUtility.getNow();
        }
        return DateUtility.getNow("HH:mm:ss");
    }

    public static String getCodeInfo(Integer stackIndex) {
        if (stackIndex == null || stackIndex < 0) {
            stackIndex = 3;
        }
        StackTraceElement ste = new Throwable().getStackTrace()[stackIndex];
        return "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
    }

    public static void end() {
        Print.warn("Application end .");
    }

    public static void start() {
        Print.warn("Application start .");
    }

    private static String toString(Object sign, String color, Object obj) {
        return Print.translate(color, sign + " at ") + Print.getCodeInfo(3) + Print.translate("MAGENTA", " - ") + Print.translate(color, obj.toString());
    }

    public static String translate(String color, String obj) {
        try {
            Class.forName("org.fusesource.jansi.Ansi");
            return Ansi.ansi().eraseScreen().render("@|" + color + " " + obj.toString() + "|@ ").toString();
        }
        catch (ClassNotFoundException e) {
            return obj.toString();
        }
    }
}

