/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt;

public class Page {
    private int pageSize;
    private int currentPage;
    private int maxPage;
    private int count;
    private int start;
    private int end;

    public Page() {
    }

    public Page(Integer currentPage, int pageSize) {
        if (currentPage == null) {
            this.currentPage = 1;
        }
        this.currentPage = currentPage;
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        if (count == null) {
            this.setCount(0);
            return;
        }
        this.count = count;
        if (count <= this.pageSize) {
            this.maxPage = 1;
        }
        if (count > this.pageSize) {
            this.maxPage = count % this.pageSize == 0 ? count / this.pageSize : count / this.pageSize + 1;
        }
        this.caculateIndex();
    }

    private void caculateIndex() {
        this.end = this.currentPage + 4;
        this.start = this.currentPage - 5;
        this.amend();
        int amend = 10 - (this.end - this.start + 1);
        if (amend > 0) {
            if (this.start == 1) {
                this.end += amend;
            } else if (this.end == this.maxPage) {
                this.start -= amend;
            }
            this.amend();
        }
    }

    private void amend() {
        if (this.end > this.maxPage) {
            this.end = this.maxPage;
        }
        if (this.start <= 0) {
            this.start = 1;
        }
    }

    public int getStartIndex() {
        return (this.currentPage - 1) * this.pageSize;
    }

    public int getCount() {
        return this.count;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return "Page [pageSize=" + this.pageSize + ", currentPage=" + this.currentPage + ", maxPage=" + this.maxPage + ", count=" + this.count + ", start=" + this.start + ", end=" + this.end + "]";
    }
}

