package com.mhdt.toolkit;

import java.util.Collection;

import com.mhdt.analyse.Validate;

/**
 * 
 * Validation of parameter type validation
 * 
 * @author LazyToShow <br>
 *         Date: 2018年10月14日 <br>
 *         Time: 下午1:52:17
 */
public class Assert {

	/**
	 * Verify the Boolean expression, otherwise throw an IllegalStateException
	 * @param expression
	 * @param message
	 */
	public static void state(boolean expression, String message) {
		if (!expression) {
			throw new IllegalStateException(message);
		}
	}

	public static void isNull(Object object, String message) {
		if (object != null) {
			throw new IllegalArgumentException(message);
		}
	}

	public static void notNull(Object object, String message) {
		if (object == null) {
			throw new IllegalArgumentException(message);
		}
	}
	
	public static <T> void notNullOrEmpty(Object object, String message) {
		if (Validate.isNullOrEmpty(object)) {
			throw new IllegalArgumentException(message);
		}
	}

	public static <T> void notNullOrEmpty(Collection<T> object, String message) {
		if (object == null || object.isEmpty()) {
			throw new IllegalArgumentException(message);
		}
	}

	public static void isTrue(boolean expression, String message) {
		if (!expression) {
			throw new IllegalArgumentException(message);
		}
	}

	public static void hasLength(String text, String message) {
		if (!StringUtility.hasLength(text)) {
			throw new IllegalArgumentException(message);
		}
	}

	public static void hasText(String text, String message) {
		if (!StringUtility.hasText(text)) {
			throw new IllegalArgumentException(message);
		}
	}

}
