package com.mhdt.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

import com.mhdt.analyse.Validate;
import com.mhdt.io.FileIO;
import com.mhdt.toolkit.FileUtility;
import com.mhdt.toolkit.FileUtility.FileType;

/**
 * 
 * <pre>
 * url工具
 * &#64;author 懒得出风头
 * Date: 2017年3月28日
 * Time： 下午9:01:08
 * </pre>
 */
public class Urls {

	/**
	 * 用本地浏览器打开链接
	 * @param url
	 * @throws Exception
	 */
	public static void open(String url) throws Exception {
		String osName = System.getProperty("os.name", "");

		if (osName.startsWith("Mac OS")) {

			Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", new Class[] { String.class })
					.invoke(null, new Object[] { url });
			
			return;

		}

		if (osName.startsWith("Windows")) {
			
			Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
			return;
			
		}

		String[] browsers = { "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape" };
		String browser = null;

		for (int count = 0; count < browsers.length && browser == null; count++)
			if (Runtime.getRuntime().exec(new String[] { "which", browsers[count] }).waitFor() == 0)
				browser = browsers[count];

		if (browser == null)
			throw new Exception("Could not find web browser");
		else
			Runtime.getRuntime().exec(new String[] { browser, url });

	}

	/**
	 * 向请求地址发送 GET / POST 请求 （支持Https） <br>
	 * 
	 * @param url  - 必须以http/https开头，不会为你的url做补全，注意异常的捕获
	 * @param args - post请求下传递参数，可以是key-value形式的 {@link Map}
	 *             也可以是{@link Object#toString()}
	 * @return 返回字节数据
	 * @throws MalformedURLException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static byte[] request(String url, Object args) throws MalformedURLException, IOException {

		byte[] buf = new byte[1024];
		HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();

		// https
		if (url.substring(0, 5).equals("https")) {
			SSLContext ctx = MyX509TrustManagerUtils();
			((HttpsURLConnection) conn).setSSLSocketFactory(ctx.getSocketFactory());
			((HttpsURLConnection) conn).setHostnameVerifier(new HostnameVerifier() {
				// 在握手期间，如果 URL 的主机名和服务器的标识主机名不匹配，则验证机制可以回调此接口的实现程序来确定是否应该允许此连接。
				@Override
				public boolean verify(String arg0, SSLSession arg1) {
					return true;
				}
			});
		}

		initRequestProperties(conn);

		if (!Validate.isNullOrEmpty(args)) {
			conn.setDoOutput(true);
			conn.setDoInput(true);
			PrintWriter out = new PrintWriter(conn.getOutputStream());

			out.print(args instanceof Map ? procssData((Map<String, Object>) args) : args.toString());

			out.flush();
			out.close();
		}

		int size = -1;
		try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
				BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());) {
			while ((size = bis.read(buf)) != -1)
				bos.write(buf, 0, size);

			bos.flush();
			return bos.toByteArray();
		}
	}

	/*
	 * HTTPS忽略证书验证,防止高版本jdk因证书算法不符合约束条件,使用继承X509ExtendedTrustManager的方式
	 */
	class MyX509TrustManager extends X509ExtendedTrustManager {

		@Override
		public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {

		}

		@Override
		public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {

		}

		@Override
		public X509Certificate[] getAcceptedIssuers() {
			return null;
		}

		@Override
		public void checkClientTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {

		}

		@Override
		public void checkClientTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2)
				throws CertificateException {

		}

		@Override
		public void checkServerTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {

		}

		@Override
		public void checkServerTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2)
				throws CertificateException {

		}

	}

	static SSLContext MyX509TrustManagerUtils() {

		TrustManager[] tm = { new Urls().new MyX509TrustManager() };
		SSLContext ctx = null;
		try {
			ctx = SSLContext.getInstance("TLS");
			ctx.init(null, tm, null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ctx;
	}

	public static void downLoad(String url, File dest, FileType type, ConfigureLink configureLink)
			throws MalformedURLException, IOException {

		downLoad(url, dest, type, configureLink, null);
	}

	public static void downLoad(String url, File dest, FileType type, Download downLoad)
			throws MalformedURLException, IOException {

		downLoad(url, dest, type, null, downLoad);
	}

	public static void downLoad(String url, File dest, FileType type) throws MalformedURLException, IOException {
		downLoad(url, dest, type, null, null);
	}

	public static void downLoad(String url, File destFile, FileType type, ConfigureLink configureLink,
			Download downLoad) throws MalformedURLException, IOException {

		byte[] buf = new byte[1024];
		HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
		initRequestProperties(conn);

		if (configureLink != null)
			configureLink.configure(conn);

		int size = -1;

		try (BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
				ByteArrayOutputStream bos = new ByteArrayOutputStream()) {

			DownInfo info = new DownInfo(conn.getContentLength(), getFileName(conn));
			if (downLoad != null)
				downLoad.loading(info);

			while ((size = bis.read(buf)) != -1) {
				bos.write(buf, 0, size);
				info.setCurrent(bos.size());
			}

			bos.flush();

			File dest = null;

			if (type.equals(FileType.Directory)) {
				dest = FileUtility.join(destFile, getFileName(conn));
			} else {
				dest = destFile;
			}

			FileIO.write(dest, bos.toByteArray(), false);
		}
	}

	public interface ConfigureLink {
		public void configure(HttpURLConnection conn);
	}

	/**
	 * 
	 * 下载中程序的附加操作。<br>
	 * 注意{@link #loading(DownInfo)}方法中的实现应该在一个线程中，可以参考{@link SimpleDownload}或继承它来使用。
	 * 
	 * @author LazyToShow<br>
	 *         Date : 2018/02/21<br>
	 *         Time: 1:00
	 */
	public interface Download {

		public void loading(DownInfo downInfo);
	}

	public static class DownInfo {

		long current;

		long length;

		String fileName;

		public DownInfo(int length, String fileName) {
			this.length = length;
			this.fileName = fileName;

		}

		public long getCurrent() {
			return current;
		}

		public void setCurrent(long current) {
			this.current = current;
		}

		public long getLength() {
			return length;
		}

		public void setLength(long length) {
			this.length = length;
		}

		public void addLength(int add) {
			this.length += add;
		}

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}
	}

	/**
	 * 根据IP返回地域，如果有省市，则空格分割 。方式为爬取http://www.ip138.com来获取地域
	 * 
	 * @param ip
	 * @return 如： 湖北 黄石
	 */
	public static String getDistrictByIp(String ip) {
		String url = "http://www.ip138.com/ips138.asp?ip=" + ip + "&action=2";
		try {
			String str = new String(request(url, null), "gb2312");
			String result = str.substring(str.indexOf("本站数据：") + 5, str.indexOf(" ", str.indexOf("本站数据") + 4));
			if (result.contains("省")) {
				return result.replace("省", "省 ");
			} else if (result.contains("市")) {
				return result.replace("市", "市 ");
			} else {
				return result;
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Get host url from url if it had.
	 * 
	 * @param url
	 * @return
	 */
	public static String getHost(String url) {
		if (Validate.isNullOrEmpty(url))
			return url;

		try {

			return new URL(url).getHost();

		} catch (MalformedURLException e) {
			return url;

		}
	}

	/** 格式化域名 */
	public static String formatNet(String net) {
		if (Validate.isNullOrEmpty(net))
			return net;
		net = net.toLowerCase();
		net = net.replaceAll("http://", "");
		if (!net.startsWith("www."))
			net = "www." + net;
		return "http://" + net;
	}

	static final String procssData(Map<String, Object> data) {
		StringBuilder sb = new StringBuilder();

		for (Map.Entry<String, Object> entry : data.entrySet()) {
			try {
				sb.append(entry.getKey() + "=" + Urls.transferred(entry.getValue().toString()) + "&");
			} catch (NullPointerException e) {
				continue;
			}
		}

		return sb.substring(0, sb.length() - 1);
	}

	static final Map<String, String> words = new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
		{
			put("+", "%2B");
			put("/", "%2F");
			put("?", "%3F");
			put("%", "%25");
			put("#", "%23");
			put("&", "%26");
			put("=", "%3D");
		}
	};

	/**
	 * Url字符转义
	 */
	public static String transferred(String str) {
		for (Map.Entry<String, String> entry : words.entrySet())
			if (str.contains(entry.getKey()))
				str = str.replace(entry.getKey(), entry.getValue());
		return str;
	}

	private static final void initRequestProperties(HttpURLConnection conn) {
		conn.setRequestProperty("accept", "*/*");
		conn.setRequestProperty("connection", "Keep-Alive");
		conn.setRequestProperty("user-agent",
				"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36");
	}

	private static String getFileName(URLConnection conn) {
		String filename = "";
		if (conn == null) {
			return null;
		}
		Map<String, List<String>> hf = conn.getHeaderFields();
		if (hf == null) {
			return null;
		}
		Set<String> key = hf.keySet();
		if (key == null) {
			return null;
		}

		out: for (String skey : key) {
			List<String> values = hf.get(skey);
			for (String value : values) {
				String result = new String(value.getBytes());
				int location = result.indexOf("filename");
				if (location >= 0) {
					result = result.substring(location + "filename".length());
					filename = result.substring(result.indexOf("=") + 1);
					break out;
				}
			}
		}

		if (Validate.isNullOrEmpty(filename)) {
			String url = conn.getURL().toString();
			filename = url.substring(url.lastIndexOf("/") + 1);
		}

		return filename;
	}

}
