package com.mhdt.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mhdt.analyse.Validate;

/**
 * <pre>
 * The class consists of three basic attributes.
 * 
 * <strong>status</strong> - The request status: success/faild
 * <strong>message</strong> -Prompt information：message The message is set as the response message. whether it succeeds or not.
 * <strong>data</strong> 	- Response data, through {@link putAttribute} To set
 * 
 * Returned as a generic request result, generated by constructing the schema.
 * 
 * eg:
 * 	RequestResult requestResult = RequestResult.status(RequestStatus.SUCCESS)
 * 		.message("Lao tie mei mao bing!")
 * 		.putAttribute("id", 1)
 *	 	.putAttribute("name", "zhang san");
 *        
 * 	prompt: message、putAttribute is nonessential.
 * </pre>
 * 
 * Date 2017年10月14日<br>
 * Time 下午9:59:33
 * 
 */
public class RequestResult {

	String status;
	String message;
	Map<String, Object> data = new HashMap<>();
	String jsonData;

	private RequestResult() {

	}

	public static RequestResult success() {
		return status(Status.SUCCESS);
	}

	public static RequestResult faild() {
		return status(Status.FAILD);
	}
	
	public  RequestResult faild(String message) {
		this.status = Status.FAILD.getValue();
		this.message(message);
		return this;
	}

	public  RequestResult faild(Throwable throwable) {
		this.status = Status.FAILD.value;
		return this.message(throwable.getMessage());
	}

	public static RequestResult status(Status status) {
		RequestResult result = new RequestResult();
		result.status = status.value;

		return result;
	}

	public RequestResult message(String message) {
		this.message = message;
		return this;
	}

	/** 设置属性到data */
	public RequestResult putAttribute(String key, Object value) {
		data.put(key, value);
		return this;
	}

	/** 从data中获取属性 */
	public Object getAttribute(String key) {
		return data.get(key);
	}

	public String getStringFromJson(String key) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(jsonData).getString(key);
	}

	public Integer getIntFromJson(String key) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(jsonData).getIntValue(key);
	}

	public <T> T getObjectFromJson(String key, Class<T> cls) {
		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(JSON.parseObject(jsonData).getString(key), cls);
	}

	public <T> List<T> getListFromJson(String key, Class<T> cls) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return new ArrayList<T>();

		List<T> list = JSON.parseArray(JSON.parseObject(jsonData).getString(key), cls);

		if (list.size() == 1 && list.get(0) == null)
			list = new ArrayList<T>();

		return list;
	}

	public enum Status {
		SUCCESS("success"), FAILD("faild");

		private final String value;

		Status(String value) {
			this.value = value;
		}

		public String getValue() {
			return value;
		}
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Map<String, Object> getData() {
		return data;
	}

	public static RequestResult parse(byte[] bytes) {
		RequestResult requestResult = new RequestResult();
		JSONObject object = JSON.parseObject(new String(bytes));

		requestResult.status = object.getString("status");
		requestResult.message = object.getString("message");
		requestResult.jsonData = object.getString("data");

		return requestResult;
	}

	/**
	 * A functional custom operation that returns {@link Status#SUCCESS} if an
	 * exception occurs in the operation or returns {@link Status#FAILD} with the
	 * exception information ( {@code message(e.getMessage())} )
	 * @param consumer
	 * @return
	 */
	public static RequestResult perform(Consumer<RequestResult> consumer) {

		RequestResult result = new RequestResult();
		
		try {
			result.status = Status.SUCCESS.value;
			consumer.accept(result);
		}catch (Exception e) {
			e.printStackTrace();
			result.status = Status.FAILD.value;
			result.setMessage(e.getMessage());
		}
		
		return result;

	}

	public void putAttribute(Map<String, Object> atttibuters) {
		data.putAll(atttibuters);
	}

}
