package com.mhdt.log;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.mhdt.toolkit.PathUtil;

/**
 * 
 * @author LazyToShow <br>
 *         Date： 2018年8月28日 <br>
 *         Time: 下午6:25:11
 */
public interface Log {

	
	/**
	 * Log level identifier
	 */
	static Map<Level, String[]> identifier = new HashMap<Level, String[]>() {
		
		private static final long serialVersionUID = 1L;

		{
			put(Level.INFO, new String[] { "[", "]" });
			put(Level.WARN, new String[] { "☆", "☆" });
			put(Level.DEBUG, new String[] { "[", "]" });
			put(Level.ERROR, new String[] { "「", "」" });
		}
	};

	/**
	 * Default log output folder path
	 */
	static final String DEFAULTOUTPATH = PathUtil.underCurrentProject() + File.separator + "log" + File.separator;

	/**
	 * Is it currently at debug {@link Level}
	 * @return
	 */
	boolean isDebugEnable();

	/**
	 * Gets the current log level
	 * @return
	 */
	Level getLevel();

	/**
	 * Set the log level, which will determine the output mode
	 * @param level
	 */
	void setLevel(Level level);

	void info(String message);

	void error(Throwable e);

	void error(String message);

	void debug(String message);

	void warn(String message);

	public static Log getDefaultLog() {
		return DefaultLog.getInstance();
	}
	
	public enum Level {

		/**
		 * Meaningful event information, such as program startup, closing event,
		 * receiving request event, etc.
		 */
		INFO("green"),

		/**
		 * Warning information, such as a program called an invalid interface, the
		 * improper use of the interface, the running state is not expected but still
		 * can continue processing;
		 */
		WARN("yellow"),

		/** Other error run-time errors; */
		ERROR("red"),

		/**
		 * Debugging information that records the details of the business process and
		 * the current state of the variable.
		 */
		DEBUG("pink");

		String color;

		private Level(String color) {
			this.color = color;
		}

		public String getColor() {
			return color;
		}

	}

	static Map<String,Log> cache = new HashMap<>();
	
	public static Log getIndependentLog(String namespace) {
		
		if(cache.containsKey(namespace))
			return cache.get(namespace);
		
		return new IndependentLog(namespace);
	}
	
	public static Log getIndependentLog(String namespace,File outputFolder) {
		return new IndependentLog(namespace,outputFolder);
	}
	
	
}
