package com.mhdt.log;

import java.io.File;

import com.mhdt.Print;
import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.FileUtility;

/**
 * 
 * @author LazyToShow <br>
 * Date： 2018年8月29日 <br>
 * Time: 上午10:18:45
 */
public class IndependentLog extends AbstractLog {

	String namespace;

	File outputFolder = new File(Log.DEFAULTOUTPATH);

	public IndependentLog(String namespace) {
		this.namespace = namespace;
	}
	
	@Override
	protected String generatingOutput(Level level, Object message) {

		String[] identifier = Log.identifier.get(level);

		return identifier[0] + level.toString() + identifier[1] + "	" + DateUtility.getNow("HH:mm:ss") +" "
				+ Print.getCodeInfo(4) + " - "+namespace+" " + (message == null ? "\tnull" : message.toString());
	}

	public IndependentLog(String namespace, File outputFolder) {

		if (outputFolder == null)
			throw new NullPointerException("输出文件夹为null");

		if (Validate.isNullOrEmpty(namespace))
			throw new NullPointerException("命名空间为空");

		if (!outputFolder.exists())
			FileUtility.createFloder(outputFolder);

		this.namespace = namespace;

	}

	@Override
	public File getLogFile() {

		File file = FileUtility.join(outputFolder, DateUtility.today() + "-" + namespace + ".txt");
		if (!file.exists())
			FileUtility.createFile(file);
		
		return file;
	}
	
	@Override
	public File getErrorFile() {
		File file = FileUtility.join(outputFolder, DateUtility.today()  + "-error.txt");
		if (!file.exists())
			FileUtility.createFile(file);
		
		return file;
	}

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}

	public File getOutputFolder() {
		return outputFolder;
	}

	public void setOutputFolder(File outputFolder) {
		this.outputFolder = outputFolder;
	}

}
