package com.mhdt.log;

import com.mhdt.Print;
import com.mhdt.io.FileIO;
import com.mhdt.toolkit.DateUtility;

/**
 * 
 * @author LazyToShow <br>
 *         Date： 2018年8月29日 <br>
 *         Time: 上午10:51:28
 */
abstract class AbstractLog implements Log, LogOut {

	static {
		System.setErr(ExceptionPrintStream.getInstance());
	}

	public AbstractLog() {
		ExceptionPrintStream.addLogOut(this);
	}

	boolean debugEnable = true;

	@Override
	public boolean isDebugEnable() {
		return debugEnable;
	}

	Level level;

	@Override
	public Level getLevel() {
		return level;
	}

	@Override
	public void setLevel(Level level) {
		this.level = level;
		if (level == Level.DEBUG)
			this.debugEnable = true;
	}

	/**
	 * 
	 * @param level
	 * @param message
	 * @return
	 */
	protected String generatingOutput(Level level, Object message) {

		String[] identifier = Log.identifier.get(level);

		return identifier[0] + level.toString() + identifier[1] + "	" + DateUtility.getNow("HH:mm:ss") +" "
				+ Print.getCodeInfo(4) + "	- " + (message == null ? "\tnull" : message.toString());
	}

	/**
	 * Output content at log level
	 * @param level
	 * @param outMessage
	 */
	protected void outputLog(Level level, String outMessage) {
		FileIO.write(getLogFile(), "\r\n" + outMessage, true);
	}

	@Override
	public void info(String message) {
		String outMessage = generatingOutput(Level.INFO, message);
		System.out.println(outMessage);
		outputLog(Level.INFO, outMessage);
	}

	@Override
	public void warn(String message) {
		String outMessage = generatingOutput(Level.WARN, message);
		System.out.println(outMessage);
		outputLog(Level.WARN, outMessage);
	}

	@Override
	public void debug(String message) {
		String outMessage = generatingOutput(Level.DEBUG, message);
		System.out.println(outMessage);
		outputLog(Level.DEBUG, outMessage);
	}

	@Override
	public void error(Throwable e) {
		e.printStackTrace();
	}

	@Override
	public void error(String message) {
		System.out.println(Print.getCodeInfo(3)+" -	"+message);
		outputLog(Level.ERROR, generatingOutput(Level.ERROR, message));
	}

	long lastTime;

	@Override
	public long getLastTime() {
		return lastTime;
	}

	@Override
	public void setLastTime(long timelong) {
		this.lastTime = timelong;
	}

}
