/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.ui;

import com.mhdt.Print;
import com.mhdt.system.Monitor;
import com.mhdt.system.WindowClosing;
import com.mhdt.toolkit.FrameRate;
import com.mhdt.toolkit.RamUsage;
import com.mhdt.ui.UImanager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.JPanel;

public abstract class Canvas
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Monitor,
WindowClosing {
    private static final long serialVersionUID = -3576152091142892270L;
    private volatile boolean isUpdated = false;
    private final Object UPDATE_LOCK = new Object();
    private Thread rendThread;
    private Thread updateThread;
    private BufferedImage bf;
    private VolatileImage vi;
    private Graphics2D g2d;
    private int FPS = 40;
    public boolean drawing = true;
    private boolean showFPS = true;
    private boolean showRAM = true;
    private long lastTime = 0L;
    private boolean hardwareAcceleration = true;
    private final FrameRate frameRate = new FrameRate();
    private RamUsage ramMotitor = new RamUsage();

    public Canvas() {
        this.setBackground(Color.black);
        this.rendThread = new RendThread();
        this.updateThread = new UpdateThread();
        this.setIgnoreRepaint(true);
        this.setFocusable(true);
        this.requestFocus(true);
        this.setLayout(null);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.frameRate.initialize();
    }

    private final synchronized void draw() {
        this.frameRate.calculate();
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g != null) {
            this.g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
            this.render(this.g2d);
            if (this.vi != null) {
                g.drawImage(this.vi, 0, 0, this);
            } else {
                g.drawImage((Image)this.bf, 0, 0, this);
            }
            g.finalize();
        }
    }

    private void createBackBuffer() {
        this.vi = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(this.getWidth(), this.getHeight());
        int val = this.vi.validate(this.getGraphicsConfiguration());
        if (val == 2 || !this.hardwareAcceleration) {
            Print.info("Init render: validate=" + val + ".(Does not support hardware acceleration)");
            this.vi = null;
            this.bf = new BufferedImage(this.getWidth(), this.getHeight(), 8);
            this.g2d = (Graphics2D)this.bf.getGraphics();
        } else {
            Print.info("Init render , val=" + val + ". Start the hardware acceleration");
            this.g2d = (Graphics2D)this.vi.getGraphics();
        }
    }

    protected void render(Graphics2D g2d) {
        this.drawComponents(g2d);
        this.drawFPS(g2d);
        this.drawRAM(g2d);
    }

    protected abstract void update(long var1);

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown()) {
            switch (e.getKeyCode()) {
                case 70: {
                    if (this.showFPS) {
                        this.showFPS = false;
                        break;
                    }
                    this.showFPS = true;
                    break;
                }
                case 82: {
                    this.showRAM = !this.showRAM;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public final int getFPS() {
        return this.FPS;
    }

    public final void setFPS(int fPS) {
        this.FPS = fPS;
    }

    @Override
    public void drawFPS(Graphics g) {
        if (this.showFPS) {
            g.setColor(Color.BLACK);
            g.setFont(UImanager.Font_14);
            g.drawString(this.frameRate.getFrameRate(), 21, 21);
            g.setColor(Color.WHITE);
            g.drawString(this.frameRate.getFrameRate(), 20, 20);
        }
    }

    @Override
    public void drawRAM(Graphics g) {
        if (this.showRAM) {
            g.setColor(Color.BLACK);
            g.setFont(UImanager.Font_14);
            g.drawString(this.ramMotitor.getRAM_Usage(), 21, 41);
            g.setColor(Color.WHITE);
            g.setFont(UImanager.Font_14);
            g.drawString(this.ramMotitor.getRAM_Usage(), 20, 40);
        }
    }

    protected final void drawComponents(Graphics g) {
        if (this.getComponents().length < 1) {
            return;
        }
        Component[] comps = this.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            Component c = comps[i];
            if (!c.isVisible()) continue;
            Graphics2D g2 = (Graphics2D)g.create(c.getX(), c.getY(), c.getWidth(), c.getHeight());
            try {
                c.paint(g2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            g2.dispose();
        }
    }

    @Override
    public final void setVisible(boolean flag) {
        this.drawing = flag;
        if (!this.rendThread.isAlive()) {
            this.rendThread.start();
        }
        if (!this.updateThread.isAlive()) {
            this.updateThread.start();
        }
    }

    @Override
    public final void setSize(int width, int height) {
        super.setSize(width, height);
        this.createBackBuffer();
    }

    @Override
    public final void setSize(Dimension d) {
        super.setSize(d);
        this.createBackBuffer();
    }

    @Override
    public final void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.createBackBuffer();
    }

    public void clearCompoments() {
        this.removeAll();
    }

    @Override
    public void onWindowClosing() {
        this.drawing = false;
        try {
            Print.info("Closing RendThread...");
            this.drawing = false;
            this.rendThread.join();
            Print.info("RendThread closed.");
            this.updateThread.join();
            Print.info("UpdateThread closed.");
            Print.info("Application closed.");
            System.exit(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public boolean isShowFPS() {
        return this.showFPS;
    }

    public void setShowFPS(boolean showFPS) {
        this.showFPS = showFPS;
    }

    public boolean isShowRAM() {
        return this.showRAM;
    }

    public void setShowRAM(boolean showRAM) {
        this.showRAM = showRAM;
    }

    public boolean isHardwareAcceleration() {
        return this.hardwareAcceleration;
    }

    public void setHardwareAcceleration(boolean hardwareAcceleration) {
        this.hardwareAcceleration = hardwareAcceleration;
    }

    private final class RendThread
    extends Thread {
        private RendThread() {
            this.setName("Render Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            long fpstime = (long)(Double.valueOf(1000.0) / Double.valueOf(Canvas.this.FPS) * 1000000.0);
            long now = 0L;
            while (Canvas.this.drawing) {
                long total;
                now = System.nanoTime();
                if (Canvas.this.isVisible() && Canvas.this.isShowing()) {
                    Canvas.this.draw();
                }
                if (Canvas.this.isUpdated) {
                    object = Canvas.this.UPDATE_LOCK;
                    synchronized (object) {
                        Canvas.this.UPDATE_LOCK.notify();
                        Canvas.this.isUpdated = false;
                    }
                }
                if ((total = System.nanoTime() - now) > fpstime) continue;
                try {
                    Thread.sleep((fpstime - (System.nanoTime() - now)) / 1000000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (System.nanoTime() - now < fpstime) {
                    System.nanoTime();
                }
            }
            object = Canvas.this.UPDATE_LOCK;
            synchronized (object) {
                Canvas.this.UPDATE_LOCK.notify();
            }
        }
    }

    private final class UpdateThread
    extends Thread {
        private UpdateThread() {
            this.setName("Caculate Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            Canvas.this.lastTime = currentTime;
            Object object = Canvas.this.UPDATE_LOCK;
            synchronized (object) {
                while (Canvas.this.drawing) {
                    currentTime = System.currentTimeMillis();
                    Canvas.this.update(currentTime - Canvas.this.lastTime);
                    Canvas.this.lastTime = currentTime;
                    Canvas.this.isUpdated = true;
                    try {
                        Canvas.this.UPDATE_LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

