/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.parse;

import com.mhdt.Print;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class AppclassLoad {
    public void loadJars(File source) {
        File[] files;
        if (source == null || !source.exists() || source.isFile()) {
            return;
        }
        for (File jar : files = source.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        })) {
            this.load(jar);
        }
    }

    public List<String> loadClasses(File folder) throws Exception {
        if (folder == null) {
            return null;
        }
        int root_len = folder.getAbsolutePath().length();
        if (folder.exists() && folder.isDirectory()) {
            this.load(folder);
            return this.populateClassName(folder, root_len);
        }
        return null;
    }

    private List<String> populateClassName(File source, int root_len) {
        ArrayList<String> list = new ArrayList<String>();
        Stack<File> stack = new Stack<File>();
        stack.push(source);
        while (!stack.isEmpty()) {
            File parent = (File)stack.pop();
            for (File child : this.getChilds(parent)) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                list.add(child.getAbsolutePath().substring(root_len + 1, child.getAbsolutePath().length() - 6).replace("\\", "."));
            }
        }
        return list;
    }

    private File[] getChilds(File parent) {
        return parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory() || child.getName().endsWith(".class");
            }
        });
    }

    private void load(File folder) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            URL url = folder.toURI().toURL();
            Print.info(url);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

