/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.media;

import com.mhdt.Print;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.processing.FilerException;
import javazoom.jl.player.Player;

public class Mp3Player {
    private Player player;
    private Thread thread;
    private Object source;
    private volatile boolean loop = true;

    public Mp3Player(File file) throws FilerException {
        if (!file.isFile() || !file.exists()) {
            Print.error("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528");
            throw new FilerException("");
        }
        this.source = file;
    }

    public Mp3Player(InputStream in) {
        this.source = in;
    }

    public final void play() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mp3Player.this.player = new Player((InputStream)Mp3Player.this.load(Mp3Player.this.source));
                    Mp3Player.this.player.play();
                }
                catch (Exception e) {
                    try {
                        Mp3Player.this.thread.join();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
        this.thread.start();
    }

    public final void loop() {
        this.loop = true;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Mp3Player.this.loop) {
                    try {
                        Mp3Player.this.player = new Player((InputStream)Mp3Player.this.load(Mp3Player.this.source));
                        Mp3Player.this.player.play();
                    }
                    catch (Exception e) {
                        Mp3Player.this.loop = false;
                        try {
                            Mp3Player.this.thread.join();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.thread.start();
    }

    public final void change(File file) {
        this.source = file;
        if (this.loop) {
            this.stop();
            this.loop = true;
            this.loop();
        } else {
            this.stop();
            this.play();
        }
    }

    public final void stop() {
        if (this.loop) {
            this.loop = false;
            this.player.close();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.player.close();
            }
            catch (NullPointerException e1) {
                Print.error(" Unable to stop source is empty");
                throw e1;
            }
        }
    }

    private final BufferedInputStream load(Object obj) {
        try {
            BufferedInputStream bis = null;
            if (obj instanceof File) {
                bis = new BufferedInputStream(new FileInputStream((File)obj));
            } else if (obj instanceof InputStream) {
                bis = new BufferedInputStream((InputStream)obj);
            } else {
                Print.error("can't play the source .");
            }
            return bis;
        }
        catch (Exception e) {
            Print.error("The file can not find a file : \\" + obj.toString() + "\\");
            return null;
        }
    }
}

