/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiOutPutStream
extends OutputStream {
    private FileOutputStream fos;
    private List<OutputStream> list = new ArrayList<OutputStream>();

    public MultiOutPutStream(OutputStream ... outputStreams) {
        for (OutputStream os : outputStreams) {
            if (os instanceof FileOutputStream) {
                this.fos = (FileOutputStream)os;
            }
            this.list.add(os);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream o : this.list) {
            o.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream o : this.list) {
            o.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOException e = null;
        for (OutputStream o : this.list) {
            try {
                o.write(b, off, len);
            }
            catch (IOException ioE) {
                e = ioE;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream o : this.list) {
            o.flush();
        }
    }

    @Override
    public void close() throws IOException {
        IOException e = null;
        for (OutputStream o : this.list) {
            try {
                o.close();
            }
            catch (IOException ioE) {
                e = ioE;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public FileOutputStream getFos() {
        return this.fos;
    }
}

