/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.degist;

import com.mhdt.analyse.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class DegistTool {
    private DegistTool() {
    }

    public static String md5(String psw, Encode encode) throws NullPointerException {
        if (Validate.isNullOrEmpty(psw)) {
            throw new NullPointerException("md5 source is Null.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(psw.getBytes());
            switch (encode) {
                case BINARY: {
                    return DatatypeConverter.printBase64Binary((byte[])bytes);
                }
                case HEX: {
                    return DegistTool.byteToHexStr(bytes);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(File file) {
        FileInputStream fileInputStream = null;
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((len = fileInputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            String string = DatatypeConverter.printBase64Binary((byte[])digest.digest());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String hexEncode(String message) {
        return DatatypeConverter.printHexBinary((byte[])message.getBytes());
    }

    public static String hexDecode(String message) {
        return new String(DatatypeConverter.parseHexBinary((String)message));
    }

    public static String sha(String psw) {
        if (Validate.isNullOrEmpty(psw)) {
            throw new NullPointerException("md5 source is Null.");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byts = messageDigest.digest(psw.getBytes());
            return DatatypeConverter.printBase64Binary((byte[])byts);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encode(String str) {
        return DatatypeConverter.printBase64Binary((byte[])str.getBytes());
    }

    public static String decode(String str) {
        return new String(DatatypeConverter.parseBase64Binary((String)str));
    }

    public static String byteToHexStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte bt : bytes) {
            sb.append(DegistTool.byteToHexStr(bt));
        }
        return sb.toString();
    }

    public static String byteToHexStr(byte bt) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        return new String(new char[]{Digit[bt >>> 4 & 0xF], Digit[bt & 0xF]});
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(DegistTool.hexCharToByte(hexChars[pos]) << 4 | DegistTool.hexCharToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte hexCharToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static enum Encode {
        BINARY,
        HEX;

    }
}

