/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.analyse;

import com.mhdt.analyse.Validate;
import com.mhdt.io.FileIO;
import com.mhdt.toolkit.StringUtility;
import java.io.File;

public class Statistics {
    private Statistics() {
    }

    public static int chineseCount(String content) {
        char[] chars = content.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (!Validate.isChinese(Character.valueOf(c))) continue;
            ++count;
        }
        return count;
    }

    public static int englishCount(String content) {
        char[] chars = content.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (!Validate.isEnglish(c)) continue;
            ++count;
        }
        return count;
    }

    public static int blankCount(String content) {
        char[] chars = content.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (!Validate.isBlank(c)) continue;
            ++count;
        }
        return count;
    }

    public static PI countLines(File projectFolder, String fileSuffix) {
        PI projectInfo = new PI(projectFolder);
        for (File temp : projectFolder.listFiles()) {
            if (temp.isFile()) {
                if (!temp.getName().endsWith(fileSuffix)) continue;
                projectInfo.effective_count += Statistics.caculate(temp);
                projectInfo.lines_count += FileIO.getContent(temp).split("\n").length;
                ++projectInfo.files_count;
                continue;
            }
            if (!temp.isDirectory()) continue;
            PI tempInfo = Statistics.countLines(temp, fileSuffix);
            projectInfo.effective_count += tempInfo.effective_count;
            projectInfo.lines_count += tempInfo.lines_count;
            projectInfo.files_count += tempInfo.files_count;
        }
        return projectInfo;
    }

    private static int caculate(File file) {
        String[] arrays;
        int count = 0;
        for (String temp : arrays = FileIO.getContent(file).split("\n")) {
            if (Validate.isNullOrEmpty(temp = StringUtility.removeBlankChar(temp)) || temp.startsWith("package") || temp.startsWith("import") || temp.length() < 3) continue;
            ++count;
        }
        return count;
    }

    public static class PI {
        public int lines_count;
        public int effective_count;
        public int files_count;
        public String project_name;

        public PI(File projectFolder) {
            this.project_name = projectFolder.getName().substring(projectFolder.getName().lastIndexOf(File.separator) + 1);
        }

        public String toString() {
            return "PI[\u9879\u76ee\u540d\uff1a" + this.project_name + ", \t\u6587\u4ef6\u6570\uff1a" + this.files_count + ", \t\u603b\u884c\u6570\uff1a" + this.lines_count + ",\t\t\u6709\u6548\u884c\u6570\uff1a" + this.effective_count + "]";
        }
    }
}

