package com.mhdt.parse;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import com.mhdt.Print;

/**
 * 
 * <pre>
 *
 * @author 懒得出风头
 * Date: 2017年3月9日
 * Time: 下午3:06:47
 * </pre>
 */
public class AppclassLoad {

	/**
	 * 加载目录下jar包
	 * 
	 * @param source
	 *            - lib folder
	 */
	public void loadJars(File source) {

		if (source == null || !source.exists() || source.isFile())
			return;

		File[] files = source.listFiles(new FilenameFilter() {

			@Override
			public boolean accept(File dir, String name) {
				return name.endsWith(".jar") || name.endsWith(".zip");
			}
		});

		for (File jar : files) {
			load(jar);
		}

	}

	/**
	 * ClassMenu
	 * @param folder
	 * @return
	 * @throws Exception
	 */
	public List<String> loadClasses(File folder) throws Exception {
		if (folder == null)
			return null;

		int root_len = folder.getAbsolutePath().length();

		if (folder.exists() && folder.isDirectory()) {
			load(folder);
			return populateClassName(folder, root_len);
		}

		return null;
	}

	private List<String> populateClassName(File source, int root_len) {
		List<String> list = new ArrayList<String>();

		Stack<File> stack = new Stack<>();
		stack.push(source);

		/** 迭代Root 文件将类名返回 */
		while (!stack.isEmpty()) {
			File parent = stack.pop();

			for (File child : getChilds(parent)) {
				if (child.isDirectory()) {
					stack.push(child);
				} else {

					list.add(child.getAbsolutePath().substring(root_len + 1, child.getAbsolutePath().length() - 6)
							.replace("\\", "."));
				}
			}
		}
		return list;
	}

	private File[] getChilds(File parent) {
		return parent.listFiles(new FileFilter() {

			@Override
			public boolean accept(File child) {
				return child.isDirectory() || child.getName().endsWith(".class");
			}
		});
	}

	private void load(File folder) {
		try {
			Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
			method.setAccessible(true);
			ClassLoader classLoader = ClassLoader.getSystemClassLoader();
			URL url = folder.toURI().toURL();
			Print.info(url);
			method.invoke(classLoader, url);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
