package com.mhdt.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mhdt.analyse.Validate;

/**
 * <pre>
 * 该类由3个基本属性组成
 * <strong>status(String)</strong> - 请求状态: success/faild
 * <strong>message(String)</strong> - 提示信息：message 无论成功与否设置message作为响应信息
 * <strong>data(Map)</strong> - 响应数据，通过{@link putAttribute}来设置
 * 作为一般性的请求结果返回，通过构造模式来生成
 * eg:
 *  RequestResult requestResult = 
 * 	RequestResult.
 * 	status(RequestStatus.SUCCESS).
 * 	message("hahaha").
 *        putAttribute("id", 1).
 *         putAttribute("name", "小明");
 *        
 *  提示:message、putAttribute是非必选项
 * Date 2017年10月14日
 * Time 下午9:59:33
 * </pre>
 */
public class RequestResult {

	String status;
	String message;
	Map<String, Object> data = new HashMap<>();
	String jsonData;

	private RequestResult() {

	}

	public static RequestResult status(Status status) {
		RequestResult result = new RequestResult();
		result.status = status.value;

		return result;
	}

	public RequestResult message(String message) {
		this.message = message;
		return this;
	}

	/** 设置属性到data */
	public RequestResult putAttribute(String key, Object value) {
		data.put(key, value);
		return this;
	}

	/** 从data中获取属性 */
	public Object getAttribute(String key) {
		return data.get(key);
	}

	public String getStringFromJson(String key) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(jsonData).getString(key);
	}

	public Integer getIntFromJson(String key) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(jsonData).getIntValue(key);
	}

	public <T> T getObjectFromJson(String key, Class<T> cls) {
		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return null;

		return JSON.parseObject(JSON.parseObject(jsonData).getString(key), cls);
	}

	public <T> List<T> getListFromJson(String key, Class<T> cls) {

		if (jsonData == null || Validate.isNullOrEmpty(JSON.parseObject(jsonData).getString(key)))
			return new ArrayList<T>();
		
		List<T> list = JSON.parseArray(JSON.parseObject(jsonData).getString(key), cls);
		
		if(list.size()==1 && list.get(0)==null)
			list = new ArrayList<T>();
		
		return list;
	}

	public enum Status {
		SUCCESS("success"), 
		FAILD("faild");
		
		private final String value;

		Status(String value) {
			this.value = value;
		}
		
		public String getValue() {
			return value;
		}
		

		
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Map<String, Object> getData() {
		return data;
	}

	public static RequestResult parse(byte[] bytes) {
		RequestResult requestResult = new RequestResult();
		JSONObject object = JSON.parseObject(new String(bytes));

		requestResult.status = object.getString("status");
		requestResult.message = object.getString("message");
		requestResult.jsonData = object.getString("data");

		return requestResult;
	}

}
