package com.mhdt.log;

import com.mhdt.toolkit.DateUtility;

/**
 * <pre>
 * 
 * Simple implementation of log.
 * 
 * @author lAZY_TO_SHOW
 * Date: 2018/01/15
 * Time: 11:03
 * </pre>
 */
public class SimpleLog implements Log{
	
	public SimpleLog() {
		
	}
	
	protected Class<?> cls;
	
	public SimpleLog(Class<?> cls) {
		this.cls = cls;
	}
	
	protected void print(Level level,String sign,String message) {
		
		StringBuilder sb = new StringBuilder();
		
		sb.append("["+level+"]");
		sb.append("	"+DateUtility.getNow());
		sb.append("	"+sign);
		sb.append("	");
		sb.append("	"+message);
		
		System.out.println(sb);
		
	}
	
	//package+class+method
	private String getOutPutSource(){
		if(cls==null)
		return Thread.currentThread().getStackTrace()[2].getClassName()+"."+Thread.currentThread().getStackTrace()[2].getMethodName();
		else return cls.getName();
	}

	@Override
	public void info(String message) {
		print(Level.INFO, getOutPutSource(), message);
	}

	@Override
	public void info(String sign, String message) {
		print(Level.INFO, sign, message);
	}

	@Override
	public void warn(String message) {
		if(getLevel()==Level.WARN || isDebugEnable())
			print(Level.WARN, getOutPutSource(), message);
	}

	@Override
	public void warn(String sign, String message) {
		if(getLevel().equals(Level.WARN) || isDebugEnable())
			print(Level.WARN, sign, message);
	}

	@Override
	public void debug(String message) {
		
		if(isDebugEnable())
			print(Level.DEBUG, getOutPutSource(), message);
	}

	@Override
	public void debug(String sign, String message) {
		
		if(isDebugEnable())
			print(Level.INFO, sign, message);
	}

	@Override
	public void error(String sign, String message) {
		if(getLevel()==Level.ERROR || isDebugEnable())
		print(Level.INFO, getOutPutSource(), message);
	}

	@Override
	public void error(Throwable e) {
		if(getLevel()==Level.ERROR || isDebugEnable())
		print(Level.ERROR, getOutPutSource(), e.getMessage());
	}

	@Override
	public void error(String sign, Throwable e) {
		if(getLevel()==Level.ERROR || isDebugEnable())
		print(Level.ERROR, sign, e.getMessage());
	}
	
	protected Level level = Level.INFO;

	@Override
	public boolean isDebugEnable() {
		return level==Level.DEBUG;
	}

	@Override
	public Level getLevel() {
		return level;
	}

	@Override
	public void setLevel(Level level) {
		if(level==null) {
			this.level = Level.WARN;
			warn("mhdt.log.setLevel","Level is empty and a warn level log is to be taken.");
			return;
		}
		
		this.level = level;
	}

}
