package com.mhdt.log;

public enum Level {

	/** Meaningful event information, such as program startup, closing event,
	 receiving request event, etc.*/
	INFO("green"),
	
	/** Warning information, such as a program called an invalid interface, the
	 improper use of the interface, the running state is not expected but still
	 can continue processing;*/
	WARN("yellow"),
	
	
	/** Other error run-time errors;*/
	ERROR("red"),
	
	
	/** Debugging information that records the details of the business process and
	 the current state of the variable.*/
	DEBUG("pink");
	
	
	String color;
	
	private Level(String color) {
		this.color = color;
	}

	public String getColor() {
		return color;
	}

}
