package com.mhdt.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * Many outPutStream extends OutputStream.
 * @author 懒得出风头
 * Date: 2016/07/28<br>
 * Time: 10:00
 */
public class MultiOutPutStream extends OutputStream{
	
	private FileOutputStream fos;
	private List<OutputStream> list = new ArrayList<OutputStream>();
	
	
	public MultiOutPutStream(OutputStream...outputStreams){
		for(OutputStream os : outputStreams){
			if(os instanceof FileOutputStream){
				fos = (FileOutputStream)os;
			}
			list.add(os);
		}
	}

	@Override
	public void write(int b) throws IOException {
		for(OutputStream o:list){
			o.write(b);
		}
	}
	
	@Override
	public void write(byte[] b) throws IOException {
		for(OutputStream o:list){
			o.write(b);
		}
	}
	

	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		IOException e = null;  
        for (OutputStream o:list) {  
            try {  
                o.write(b, off, len);  
            } catch (IOException ioE) {  
                e = ioE;  
            }  
        }  
          
        if (e != null) {
            throw e;  
        }  
	}

	@Override
	public void flush() throws IOException {
		for(OutputStream o : list){
			o.flush();
		}
	}

	@Override
	public void close() throws IOException {
		 IOException e = null;  
	        for (OutputStream o:list) {  
	            try {  
	                o.close();  
	            } catch (IOException ioE) {  
	                e = ioE;  
	            }  
	        }  
	          
	        if (e != null) {  
	            throw e;  
	        }  
	}
	
	public FileOutputStream getFos(){
		return fos;
	}

}
