package com.mhdt.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import com.mhdt.Print;
import com.mhdt.parse.Properties;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.FileUtility;
import com.mhdt.toolkit.PathUtil;
import com.mhdt.toolkit.StringUtility;
/**
 * Abnormal records in the program to customize the output , Of cource also record your custom log.<br>
 * For example :
 * 
 * <blockquote>
 * 		Logger logger = Logger.getDefaultLogger();<br>
 *  	logger.info(Object obj);<br>
 * </blockquote>
 * @author <strong>LazyToShow</strong><br>
 * Date: 2016/07/28<br>
 * Time： 13:01<br>
 * Email： 282854237@qq.com<br>
 * Version: 1.2
 */
public  class Logger {
	private File outFile;
	private long file_size;
	private boolean isAppend;
	private String path;
	
	private static boolean isDebug = true;
	
	private Logger(){
		path = PathUtil.underCurrentProject();
		initProperties();
		try {
			redirect();
		} catch (FileNotFoundException e) {
			Print.error("Init faild, because file not fount by the config.");
			e.printStackTrace();
		}
		
		info("Init Logger[Path:"+path+"]");
		
	}
	
	/**
	 * Initialize the configuration file
	 */
	private void initProperties(){
		
		Properties properties = new Properties();
		try {
			properties.load(new File(path+"config/logConfig.properties"));
			file_size = properties.getLong("file_size")*1024;
			isAppend = properties.getBoolean("append");
			
			outFile = new File(properties.get("path"));
			if(!outFile.exists()){
				FileUtility.createFile(outFile);
			}else if(!isAppend){
				FileIO.write(outFile, "", isAppend);
			}
			
		} catch (Exception e) {
			createDefaultConfig();
			initProperties();
		}
		
	}
	
	/**
	 * network flow redirection
	 * @throws FileNotFoundException 
	 */
	private void redirect() throws FileNotFoundException{
		
			PrintStream ps = new LogPrintStream(new MultiOutPutStream(new FileOutputStream(outFile,isAppend),System.err));  
			System.setErr(ps);
		
	}
	
	/**
	 * In the default directory to create the default configuration file .
	 */
	private void createDefaultConfig() {
		Properties pro = new Properties();
		pro.putAnnotation("Log path (Defaults to the current project log/log.txt)");
		pro.put("path",path+"log/log.txt");
		pro.putAnnotation("<Whether additional on the original log(boolean)");
		pro.put("append",true);
		pro.putAnnotation("Log file size,The default (512 Kb). More than some other build files");
		pro.put("file_size",512);
		pro.save(new File(path+"config/logConfig.properties"));
	}

	
	public synchronized void debug(Object obj){
		String info = "[Debug] ["+DateUtility.getNow()+"]"+getCommonOut()+"- "+obj.toString();
		try {
			judgeSize(info.length());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		System.err.println(info);
	}
	
	public static void main(String[] args) {
		
		Logger.getDefaultLogger().debug("12222");
		
	}
	
	public synchronized void info(Object obj){
		String info = "[Info] ["+DateUtility.getNow()+"]"+getCommonOut()+" - "+obj.toString();
		System.out.println(info);
		try {
			judgeSize(info.length());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		write(info);
	}
	
	public synchronized void warn(Object obj){
		String info = "[Warn] ["+DateUtility.getNow()+"]"+getCommonOut()+" - "+obj.toString();
		System.out.println(info);
		try {
			judgeSize(info.length());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		write(info);
	}
	
	
	private  void write(String info){
		FileIO.write(outFile, info+"\r\n", true);
	}
	
	/** 
	 * Judge the size is  or not pass size ARG.
	 * @param len
	 * @throws FileNotFoundException 
	 */
	private void judgeSize(long len) throws FileNotFoundException{
		
		long length = outFile.length();
		if(length+len>=file_size){
			String pureName = FileUtility.getPureName(outFile);
			Integer index = StringUtility.extractInteger(pureName);
			
			if(index==null){
				index = 1;
			}else{
				index++;
			}
			
			String path = outFile.getAbsolutePath();
			outFile = new File(path.substring(0,path.lastIndexOf("\\")+1)+"log"+index+".txt");
			FileUtility.createFile(outFile);
			redirect();
			
		}
	}
	public boolean isDebugEnabled(){
		return isDebug;
	}
	
	public void setDebugEnabled(boolean flag){
		isDebug = flag;
	}
	
	//package+class+method
	private String getCommonOut(){
		return Thread.currentThread().getStackTrace()[2].getClassName()+"."+Thread.currentThread().getStackTrace()[2].getMethodName();
	}
	
	
	/**
	 * <p>The static only way of the default implementation .</p>
	 * you can set record path conver default , the default config file under  project config floder and
	 * has two options - the path Of save log.txt,
	 * 					 is append or cover the old record
	 * 
	 * @return logger.Instance.
	 */
	public static Logger getDefaultLogger(){
		return LazyHolder.logger;
	}

	private static class LazyHolder{
		private static Logger logger = new Logger();
	}
	
}
