package com.mhdt.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

import com.mhdt.toolkit.DateUtility;

/**
 * 
 *<pre>
 * 系统抛出异常时自动附带触发时间
 * @author 懒得出风头
 * Date: 2017年10月15日
 * Time: 下午4:35:28
 *</pre>
 */
public class LogPrintStream extends PrintStream{

	

	public LogPrintStream(MultiOutPutStream out) {
		super(out);
	}

	String lastTime;
	
	@Override
	public void print(String s) {
		if(out instanceof MultiOutPutStream ){
			String now = DateUtility.getNow();
			if(!now.equals(lastTime)){
				MultiOutPutStream mos = (MultiOutPutStream) out;
				FileOutputStream fos = mos.getFos();
				try {
					fos.write(("["+now+"]\r\n").getBytes());
					fos.flush();
				} catch (IOException e) {
					e.printStackTrace();
				}
				lastTime = now;
			}
			
			
		}
		super.print(s);
	}

	
	
	

}
