package com.mhdt;


import com.mhdt.toolkit.DateUtility;
import static org.fusesource.jansi.Ansi.*;

/**
 * out test sentense
 * 
 * @author LazyToShow <br>
 *         Date: 2016/06/08 <br>
 *         Time: 15:55
 * Email: 282854237@qq.com
 */
public class Print {

	public static void error(Object obj) {
		System.out.println(toString("[Erro]", "RED", obj));
	}

	public static void info(Object obj) {
		System.out.println(toString("[Info]", "CYAN", obj));
	}

	public static void warn(Object obj) {
		System.out.println(toString("[Warn]", "WHITE", obj));
	}

	private static String toString(Object sign, String color, Object obj) {
		return translate(color, sign + " at ") + getCodeInfo(3) + translate("MAGENTA", " - ") + translate(color, obj.toString());

	}

	static int lastTime;

	@SuppressWarnings("unused")
	private static String getTime() {
		if (DateUtility.getNowForInt() - lastTime > 5) {
			lastTime = DateUtility.getNowForInt();
			return DateUtility.getNow();
		} else {
			return DateUtility.getNow("HH:mm:ss");
		}
	}

	public static String getCodeInfo(Integer i) {
		if (i == null || i < 0)
			i = 3;
		StackTraceElement ste = new Throwable().getStackTrace()[i];
		/**
		 * IDEA
		 * return ste.getClassName()+"."+ste.getMethodName()+"("+ste.getFileName()+":"+ste.getLineNumber()+")";
		 */
		return "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
	}


	public static void end() {
		warn("Application end .");
	}

	public static void start() {
		warn("Application start .");
	}

	public static void info(String message, int i) {
		System.out.println(getCodeInfo(i) + message);
	}

	/**
	 * Converts a string to an <strong>ANSI</strong> encoding a new string of the specified color.
	 * <br>If you are using eclipse, download <strong>ANSI Escape in Console </strong> at the store.
	 * @param color - {@link Color}
	 * @param obj - By {@link Object#toString()} value.
	 * @return
	 */
	public static String translate(String color, String obj) {
		try {
			Class.forName("org.fusesource.jansi.Ansi");
			return ansi().eraseScreen().render("@|" + color + " " + obj.toString() + "|@ ").toString();
		} catch (ClassNotFoundException e) {
			return obj.toString();
		}
	}

}
