/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.analyse.Validate;
import java.io.File;
import java.net.URL;

public class PathUtil {
    private PathUtil() {
    }

    public static String underWebContent() {
        String path = PathUtil.getClassPath();
        path = path.indexOf("WebContent") != -1 ? path.substring(0, path.indexOf("WebContent") + "WebContent".length()) + "/" : PathUtil.underCurrentProject();
        return path;
    }

    public static String under(String menu) {
        String path = PathUtil.getClassPath();
        if (path.indexOf(menu) != -1) {
            path = path.substring(0, path.indexOf(menu) + menu.length()) + "/";
        }
        return path;
    }

    public static String underSrc(String addTo) throws NullPointerException {
        try {
            String path = PathUtil.class.getResource("/" + addTo).getPath();
            return path;
        }
        catch (NullPointerException e) {
            System.out.println(PathUtil.class.getResource("/").getPath() + addTo);
            throw e;
        }
    }

    public static String getClassPath() {
        URL url = PathUtil.class.getResource("/");
        if (url == null) {
            url = PathUtil.class.getResource("");
        }
        String path = url.getPath();
        return path;
    }

    public static String underCurrentProject() {
        String temp;
        String path = PathUtil.getClassPath();
        if (!path.contains(temp = new File("").getAbsolutePath().replace("\\", "/"))) {
            return temp;
        }
        if (path.contains("jar!")) {
            int index = path.indexOf("jar!");
            path = path.substring(0, index);
            index = path.lastIndexOf("/");
            path = path.substring(0, index + 1);
        }
        if (path.contains("WebContent")) {
            path = path.substring(0, path.indexOf("WebContent"));
        } else if (path.contains("WEB-INF")) {
            path = path.substring(0, path.indexOf("WEB-INF"));
        } else if (path.contains("bin")) {
            path = path.substring(0, path.indexOf("bin"));
        } else if (path.contains("classes")) {
            path = path.substring(0, path.indexOf("classes"));
        }
        if (!Validate.isNullOrEmpty(path) && path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        return path;
    }
}

