/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.Print;
import java.awt.Point;
import java.lang.reflect.Field;
import java.math.BigDecimal;

public class MathUtility {
    public static double division(Object molecule, Object denominator, int scale) throws NumberFormatException {
        try {
            double param1 = Double.parseDouble(molecule.toString());
            double param2 = Double.parseDouble(denominator.toString());
            if (param2 == 0.0) {
                return 0.0;
            }
            double result = Double.parseDouble(String.format("%." + scale + "f", param1 / param2));
            return result;
        }
        catch (NumberFormatException e) {
            Print.error("Input the correct number");
            throw e;
        }
    }

    public static double keepDecimalPoint(double f, int digit) {
        return new BigDecimal(f).setScale(2, 4).doubleValue();
    }

    public static int square(int x) {
        return x * x;
    }

    public static double getBiger(double a, double b) {
        if ((a = Math.abs(a)) > (b = Math.abs(b))) {
            return a;
        }
        return b;
    }

    public static int getDivisionValue(int a) {
        return Math.abs(a / a);
    }

    public static double getAngle(Point p1, Point p2) {
        int x = p2.x - p1.x;
        int y = p2.y - p1.y;
        double hypotenuse = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cos = (double)x / hypotenuse;
        double radian = Math.acos(cos);
        double angle = 180.0 / (Math.PI / radian);
        if (y < 0) {
            angle = -angle;
        } else if (y == 0 && x < 0) {
            angle = 180.0;
        }
        return angle;
    }

    public static void swap(Integer a, Integer b) {
        try {
            Field f = Integer.class.getDeclaredField("value");
            f.setAccessible(true);
            Integer temp = new Integer(a);
            try {
                f.set(a, (int)b);
                f.set(b, temp);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double _x = Math.abs(x2 - x1);
        double _y = Math.abs(y2 - y1);
        return Math.sqrt(_x * _x + _y * _y);
    }
}

