/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.Print;
import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class FileUtility {
    private FileUtility() {
    }

    public static File randomFileName(File folder) {
        File[] files = folder.listFiles();
        Random r = new Random();
        return files[r.nextInt(files.length)];
    }

    public static void remove(String path) {
        FileUtility.remove(new File(path));
    }

    public static void remove(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtility.remove(files[i]);
                }
                file.delete();
            }
        }
    }

    public static String getFormat(File file) {
        if (!file.exists() || file.getName().indexOf(".") == -1) {
            return null;
        }
        return file.getName().substring(file.getName().lastIndexOf(".") + 1);
    }

    public static boolean createFloder(File floder) {
        boolean flag = true;
        if (!floder.exists()) {
            try {
                flag = floder.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
                flag = false;
            }
        }
        return flag;
    }

    public static boolean createFile(File file) {
        if (!file.exists()) {
            try {
                File floder;
                if (!Validate.isNullOrEmpty(file.getParent()) && !(floder = new File(file.getParent())).exists()) {
                    FileUtility.createFloder(floder);
                }
                return file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static String getLastDerectory(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        String parent = path.substring(0, path.lastIndexOf("\\") + 1);
        return parent;
    }

    public static boolean rename(File file, String name) {
        if (file == null || !file.exists()) {
            throw new NullPointerException("\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (file.isDirectory()) {
            File newFile = new File(FileUtility.getLastDerectory(file) + name);
            return file.renameTo(newFile);
        }
        if (file.isFile()) {
            String format = FileUtility.getFormat(file);
            File newFile = null;
            newFile = Validate.isNullOrEmpty(format) ? new File(FileUtility.getLastDerectory(file) + name) : (name.endsWith("." + format) ? new File(FileUtility.getLastDerectory(file) + name) : new File(FileUtility.getLastDerectory(file) + name + "." + format));
            if (newFile != null) {
                return file.renameTo(newFile);
            }
        }
        return false;
    }

    public static boolean shear(File src, File dest, FileType destFileType) {
        if (src == null || !src.exists()) {
            throw new NullPointerException("\u6e90\u6587\u4ef6[src]\u4e3a 'Null' \u6216 \u4e0d\u5b58\u5728");
        }
        if (src.isDirectory()) {
            return FileUtility.shearFolder(src, dest, destFileType);
        }
        if (src.isFile()) {
            return FileUtility.shearFile(src, dest, destFileType);
        }
        return false;
    }

    private static boolean shearFolder(File src, File dest, FileType destFileType) {
        if (destFileType != FileType.Directory) {
            Print.error("\u526a\u5207\u6587\u4ef6\u5939: \u76ee\u6807\u6587\u4ef6[dest]\u4e5f\u5fc5\u987b\u662f\u6587\u4ef6\u5939");
            return false;
        }
        dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
        FileUtility.createFloder(dest);
        File[] files = src.listFiles();
        if (files.length > 0) {
            for (File temp : files) {
                File n = new File(dest.getAbsolutePath() + "/" + temp.getName());
                if (!FileUtility.copyFile(temp, n)) continue;
                temp.delete();
            }
        }
        src.delete();
        return true;
    }

    private static boolean shearFile(File src, File dest, FileType destFileType) {
        if (destFileType == FileType.File) {
            FileUtility.createFloder(new File(FileUtility.getLastDerectory(dest)));
            if (FileUtility.copyFile(src, dest)) {
                src.delete();
                return true;
            }
            return false;
        }
        if (destFileType == FileType.Directory) {
            FileUtility.createFloder(dest);
            if (FileUtility.copyFile(src, new File(dest.getAbsolutePath() + "/" + src.getName()))) {
                src.delete();
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean copy(File src, File dest, FileType destFileType) {
        if (src.isFile()) {
            if (destFileType == FileType.Directory) {
                dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
            }
            FileUtility.createFile(dest);
            return FileUtility.copyFile(src, dest);
        }
        if (src.isDirectory()) {
            if (destFileType == FileType.File) {
                Print.error("\u590d\u5236\u6587\u4ef6\u5939-\u5931\u8d25, \u56e0\u4e3a: \u51fa\u4e8e\u6b67\u4e49\u7684\u8003\u8651(\u590d\u5236\u6587\u4ef6\u5939\u5230\u6587\u4ef6 ??) - \u8bf7\u5c06\u6587\u4ef6\u5939\u4f5c\u4e3a\u8f93\u51fa\u9879[dest]");
                return false;
            }
            return FileUtility.copyFolder(src, dest);
        }
        return false;
    }

    private static boolean copyFolder(File src, File dest) {
        try {
            File[] files;
            dest = new File(dest.getAbsoluteFile() + "/" + src.getName());
            FileUtility.createFloder(dest);
            for (File file : files = src.listFiles()) {
                FileUtility.copyFile(file, new File(dest.getAbsoluteFile() + "/" + file.getName()));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File src, File dest) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            in = fis.getChannel();
            out = fos.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fis.close();
                in.close();
                fos.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getPureName(File file) {
        if (file == null || !file.exists()) {
            throw new NullPointerException("\u6587\u4ef6\u4e3a\u7a7a:" + file.getAbsolutePath());
        }
        String name = file.getName();
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static List<String> childies(File folder) {
        if (folder == null || folder.exists() || !folder.isDirectory()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        List<File> fs = Arrays.asList(folder.listFiles());
        Collections.sort(fs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                try {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    return StringUtility.extractInteger(name1) - StringUtility.extractInteger(name2);
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        for (File f : fs) {
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    public static File[] findByPrefix(File folder, Object prefix) {
        ArrayList<File> list = new ArrayList<File>();
        String preName = prefix.toString();
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(Arrays.asList(FileUtility.findByPrefix(file, prefix)));
                continue;
            }
            if (!file.isFile() || !file.getName().startsWith(preName)) continue;
            list.add(file);
        }
        return list.toArray(new File[1]);
    }

    public static File join(File foleder, String fileName) {
        return new File(foleder.getAbsolutePath() + File.separator + fileName);
    }

    public static enum FileType {
        File,
        Directory;

    }
}

