/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.toolkit;

import com.mhdt.analyse.Validate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtility {
    private static Map<Character, Character> wordFigure = new HashMap<Character, Character>();
    private static final List<String> yyyyMMdd;

    private DateUtility() {
    }

    public static String format(String date) {
        String source;
        if (Validate.isNullOrEmpty(date)) {
            return date;
        }
        date = date.replace("\u516c\u5143", "");
        char[] chardate = date.toCharArray();
        StringBuffer time = new StringBuffer();
        for (int i = 0; i < chardate.length; ++i) {
            if (wordFigure.containsKey(Character.valueOf(chardate[i]))) {
                if (chardate[i] == '\u5341' || chardate[i] == '\u62fe') {
                    if (i > 0 && wordFigure.containsKey(Character.valueOf(chardate[i - 1])) && i < chardate.length - 1 && !wordFigure.containsKey(Character.valueOf(chardate[i + 1]))) {
                        time.append("0");
                        continue;
                    }
                    if (i > 0 && wordFigure.containsKey(Character.valueOf(chardate[i - 1]))) continue;
                    if (i < chardate.length - 1 && !wordFigure.containsKey(Character.valueOf(chardate[i + 1]))) {
                        time.append("10");
                        continue;
                    }
                    time.append("1");
                    continue;
                }
                if (chardate[i] == '\u5eff') {
                    if (i == chardate.length - 1) {
                        time.append("20");
                        continue;
                    }
                    if (i < chardate.length - 1 && !wordFigure.containsKey(Character.valueOf(chardate[i + 1]))) {
                        time.append("20");
                        continue;
                    }
                    time.append("2");
                    continue;
                }
                time.append(wordFigure.get(Character.valueOf(chardate[i])));
                continue;
            }
            time.append(chardate[i]);
        }
        String result = time.toString();
        Matcher matcher = Pattern.compile("(?<![0-9]{2})([01][1-9]\u5e74)(?!(\u6765|\u540e))").matcher(result);
        while (matcher.find()) {
            source = matcher.group();
            result = result.replaceFirst(source, "20" + source);
        }
        matcher = Pattern.compile("(?<![0-9]{2})([789][1-9]\u5e74)").matcher(result);
        while (matcher.find()) {
            source = matcher.group();
            result = result.replaceFirst(source, "19" + source);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(DateUtility.stringToInt("2017/01/17"));
        System.out.println(DateUtility.stringToInt("2017/01/17\u53f7"));
    }

    public static int stringToInt(String time) {
        SimpleDateFormat sdf;
        if (Validate.isNullOrEmpty(time)) {
            return 0;
        }
        time = DateUtility.format(time);
        for (int i = 0; i < yyyyMMdd.size(); ++i) {
            sdf = new SimpleDateFormat(yyyyMMdd.get(i));
            try {
                long date = sdf.parse(time).getTime();
                return (int)(date / 1000L);
            }
            catch (ParseException e) {
                continue;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("^[1-2]\\d{3}", "yyyy");
        map.put("^[1-2]\\d{3}\u5e74$", "yyyy\u5e74");
        map.put("^[1-2]\\d{3}[\\.][0-9]{1,2}", "yyyy.MM");
        map.put("^[1-2]\\d{3}[\\-][0-9]{1,2}", "yyyy-MM");
        map.put("^[1-2]\\d{3}\\-[0-9]{1,2}\u6708$", "yyyy-MM\u6708");
        map.put("^[1-2]\\d{3}\u5e74[0-9]{1,2}$", "yyyy\u5e74MM");
        map.put("^[1-2]\\d{3}\u5e74[0-9]{1,2}\u6708$", "yyyy\u5e74MM\u6708");
        map.put("^[1-2]\\d{3}/[0-9]{1,2}/[0-9]{1,2}$", "yyyy/MM/dd");
        map.put("^[1-2]\\d{3}[0|1][0-9][0-3][0-9]$", "yyyyMMdd");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Matcher m = Pattern.compile(key).matcher(time);
            if (!m.matches()) continue;
            try {
                sdf = new SimpleDateFormat((String)entry.getValue());
                long date = sdf.parse(time).getTime();
                return (int)(date / 1000L);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static int stringToInt(String time, String format) {
        if (Validate.isNullOrEmpty(time) || time.length() < 6) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Date date = sdf.parse(time);
            return (int)(date.getTime() / 1000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String intToString(int time) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long l = (long)time * 1000L;
        String result = sf.format(new Date(l));
        if (result.endsWith("00:00:00")) {
            sf = new SimpleDateFormat("yyyy-MM-dd");
            result = sf.format(new Date(l));
        }
        return result;
    }

    public static String intToString(int time, String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(new Date((long)time * 1000L));
    }

    public static String getNow() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(date);
    }

    public static String getNow(String format) {
        if (Validate.isNullOrEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(date);
    }

    public static int getNowForInt() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static String today() {
        int now = DateUtility.getNowForInt();
        return DateUtility.intToString(now, "yyyy-MM-dd");
    }

    public static String yesterday() {
        int yesterday = DateUtility.getNowForInt() - 86400;
        return DateUtility.intToString(yesterday, "yyyy-MM-dd");
    }

    static {
        wordFigure.put(Character.valueOf('\u039f'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u25cb'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\uff2f'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('O'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\uff10'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u96f6'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u3007'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\ufffd'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u4e00'), Character.valueOf('1'));
        wordFigure.put(Character.valueOf('\u58f9'), Character.valueOf('1'));
        wordFigure.put(Character.valueOf('\u4e8c'), Character.valueOf('2'));
        wordFigure.put(Character.valueOf('\uff12'), Character.valueOf('2'));
        wordFigure.put(Character.valueOf('\u8d30'), Character.valueOf('2'));
        wordFigure.put(Character.valueOf('\u4e09'), Character.valueOf('3'));
        wordFigure.put(Character.valueOf('\u53c1'), Character.valueOf('3'));
        wordFigure.put(Character.valueOf('\u56db'), Character.valueOf('4'));
        wordFigure.put(Character.valueOf('\uff14'), Character.valueOf('4'));
        wordFigure.put(Character.valueOf('\u8086'), Character.valueOf('4'));
        wordFigure.put(Character.valueOf('\u4e94'), Character.valueOf('5'));
        wordFigure.put(Character.valueOf('\u4f0d'), Character.valueOf('5'));
        wordFigure.put(Character.valueOf('\u516d'), Character.valueOf('6'));
        wordFigure.put(Character.valueOf('\uff16'), Character.valueOf('6'));
        wordFigure.put(Character.valueOf('\u9646'), Character.valueOf('6'));
        wordFigure.put(Character.valueOf('\u4e03'), Character.valueOf('7'));
        wordFigure.put(Character.valueOf('\u67d2'), Character.valueOf('7'));
        wordFigure.put(Character.valueOf('\u516b'), Character.valueOf('8'));
        wordFigure.put(Character.valueOf('\u634c'), Character.valueOf('8'));
        wordFigure.put(Character.valueOf('\u4e5d'), Character.valueOf('9'));
        wordFigure.put(Character.valueOf('\u7396'), Character.valueOf('9'));
        wordFigure.put(Character.valueOf('\u5341'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u62fe'), Character.valueOf('0'));
        wordFigure.put(Character.valueOf('\u5eff'), Character.valueOf('2'));
        yyyyMMdd = new ArrayList<String>(){
            private static final long serialVersionUID = -750877648575959375L;
            {
                this.add("yyyy-MM-dd");
                this.add("yyyy-MM-dd HH:mm:ss");
                this.add("yyyy-MM-dd HH:mm");
                this.add("yyyy/MM/dd");
                this.add("yyyy/MM/dd HH:mm:ss");
                this.add("yyyy/MM/dd HH:mm");
                this.add("yyyy\u5e74MM\u6708dd");
                this.add("yyyy\u5e74MM\u6708dd HH:mm:ss");
                this.add("yyyy\u5e74MM\u6708dd HH:mm");
                this.add("yyyy.MM.dd");
                this.add("yyyy.MM.dd HH:mm:ss");
                this.add("yyyy.MM.dd HH:mm");
            }
        };
    }
}

