/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.parse;

import com.mhdt.analyse.Validate;
import com.mhdt.io.IMGIO;
import com.mhdt.toolkit.Reflect;
import groovy.util.Node;
import groovy.util.XmlParser;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XMLCompomentBuild {
    public JMenuBar parseJMenuBar(String id, String XMLPath) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (Validate.isNullOrEmpty(id)) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Validate.isNullOrEmpty(XMLPath)) {
            throw new IllegalArgumentException("XMLPath");
        }
        System.out.println("[info] \u5f00\u59cb\u89e3\u6790 ID=" + id + "  PATH=" + XMLPath);
        try {
            Node root = new XmlParser().parse(XMLPath);
            List childs = root.children();
            Node node = null;
            for (Node child : childs) {
                if (!child.get("@id").equals(id)) continue;
                node = child;
                break;
            }
            if (node != null) {
                JMenuBar mb = new JMenuBar();
                this.processCompoments(mb, node);
                return mb;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        System.out.println("[error] \u89e3\u6790\u5931\u8d25");
        return null;
    }

    private final void processCompoments(Component compoment, Node node) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List childs = node.children();
        for (Node n : childs) {
            System.out.println(n.name());
            Reflect.invokeMethod(this, "merge" + n.name(), new Object[]{compoment, n});
        }
    }

    public void mergeJMenu(JMenuBar mb, Node root) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JMenu jmenu = new JMenu(String.valueOf(root.get("@id")));
        mb.add(jmenu);
        if (!Validate.isNullOrEmpty(root.get("@ico").toString())) {
            jmenu.setIcon(IMGIO.load(root.get("@ico").toString()));
        }
        this.processCompoments(jmenu, root);
    }

    public void mergeJMenuItem(JMenu jmenu, Node root) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JMenuItem it = new JMenuItem(String.valueOf(root.get("@id")));
        if (!Validate.isNullOrEmpty(root.get("@action").toString())) {
            it.setActionCommand(String.valueOf(root.get("@action")));
        }
        if (!Validate.isNullOrEmpty(root.get("@mnemonic").toString())) {
            it.setMnemonic(String.valueOf(root.get("@mnemonic")).charAt(0));
        }
        if (!Validate.isNullOrEmpty(root.get("@ico").toString())) {
            it.setIcon(IMGIO.load(String.valueOf(root.get("@ico"))));
        }
        jmenu.add(it);
        this.processCompoments(it, root);
    }

    private XMLCompomentBuild() {
    }

    public static XMLCompomentBuild getInstance() {
        return LazyHolder.build;
    }

    private static class LazyHolder {
        private static XMLCompomentBuild build = new XMLCompomentBuild();

        private LazyHolder() {
        }
    }
}

