/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.log;

import com.mhdt.log.Level;
import com.mhdt.log.Log;
import com.mhdt.toolkit.DateUtility;

public class SimpleLog
implements Log {
    protected Class<?> cls;
    protected Level level = Level.INFO;

    public SimpleLog() {
    }

    public SimpleLog(Class<?> cls) {
        this.cls = cls;
    }

    protected void print(Level level, String sign, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + (Object)((Object)level) + "]");
        sb.append("\t" + DateUtility.getNow());
        sb.append("\t" + sign);
        sb.append("\t");
        sb.append("\t" + message);
        System.out.println(sb);
    }

    private String getOutPutSource() {
        if (this.cls == null) {
            return Thread.currentThread().getStackTrace()[2].getClassName() + "." + Thread.currentThread().getStackTrace()[2].getMethodName();
        }
        return this.cls.getName();
    }

    @Override
    public void info(String message) {
        this.print(Level.INFO, this.getOutPutSource(), message);
    }

    @Override
    public void info(String sign, String message) {
        this.print(Level.INFO, sign, message);
    }

    @Override
    public void warn(String message) {
        if (this.getLevel() == Level.WARN || this.isDebugEnable()) {
            this.print(Level.WARN, this.getOutPutSource(), message);
        }
    }

    @Override
    public void warn(String sign, String message) {
        if (this.getLevel().equals((Object)Level.WARN) || this.isDebugEnable()) {
            this.print(Level.WARN, sign, message);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnable()) {
            this.print(Level.DEBUG, this.getOutPutSource(), message);
        }
    }

    @Override
    public void debug(String sign, String message) {
        if (this.isDebugEnable()) {
            this.print(Level.INFO, sign, message);
        }
    }

    @Override
    public void error(String sign, String message) {
        if (this.getLevel() == Level.ERROR || this.isDebugEnable()) {
            this.print(Level.INFO, this.getOutPutSource(), message);
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.getLevel() == Level.ERROR || this.isDebugEnable()) {
            this.print(Level.ERROR, this.getOutPutSource(), e.getMessage());
        }
    }

    @Override
    public void error(String sign, Throwable e) {
        if (this.getLevel() == Level.ERROR || this.isDebugEnable()) {
            this.print(Level.ERROR, sign, e.getMessage());
        }
    }

    @Override
    public boolean isDebugEnable() {
        return this.level == Level.DEBUG;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        if (level == null) {
            this.level = Level.WARN;
            this.warn("mhdt.log.setLevel", "Level is empty and a warn level log is to be taken.");
            return;
        }
        this.level = level;
    }
}

