/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.io;

import com.mhdt.Print;
import com.mhdt.io.FileIO;
import com.mhdt.io.LogPrintStream;
import com.mhdt.io.MultiOutPutStream;
import com.mhdt.parse.Properties;
import com.mhdt.toolkit.DateUtility;
import com.mhdt.toolkit.FileUtility;
import com.mhdt.toolkit.PathUtil;
import com.mhdt.toolkit.StringUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class Logger {
    private File outFile;
    private long file_size;
    private boolean isAppend;
    private String path = PathUtil.underCurrentProject();
    private static boolean isDebug = true;

    private Logger() {
        this.initProperties();
        try {
            this.redirect();
        }
        catch (FileNotFoundException e) {
            Print.error("Init faild, because file not fount by the config.");
            e.printStackTrace();
        }
        this.info("Init Logger[Path:" + this.path + "]");
    }

    private void initProperties() {
        Properties properties = new Properties();
        try {
            properties.load(this.path + "config/logConfig.properties");
            this.file_size = properties.getLong("file_size") * 1024L;
            this.isAppend = properties.getBoolean("append");
            this.outFile = new File(properties.get("path"));
            if (!this.outFile.exists()) {
                FileUtility.createFile(this.outFile);
            } else if (!this.isAppend) {
                FileIO.write(this.outFile, "", this.isAppend);
            }
        }
        catch (Exception e) {
            this.createDefaultConfig();
            this.initProperties();
        }
    }

    private void redirect() throws FileNotFoundException {
        LogPrintStream ps = new LogPrintStream(new MultiOutPutStream(new FileOutputStream(this.outFile, this.isAppend), System.err));
        System.setErr(ps);
    }

    private void createDefaultConfig() {
        Properties pro = new Properties();
        pro.putAnnotation("Log path (Defaults to the current project log/log.txt)");
        pro.put("path", this.path + "log/log.txt");
        pro.putAnnotation("<Whether additional on the original log(boolean)");
        pro.put("append", true);
        pro.putAnnotation("Log file size,The default (512 Kb). More than some other build files");
        pro.put("file_size", 512);
        pro.save(new File(this.path + "config/logConfig.properties"));
    }

    public synchronized void debug(Object obj) {
        String info = "[Debug] [" + DateUtility.getNow() + "]" + this.getCommonOut() + "- " + obj.toString();
        try {
            this.judgeSize(info.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.err.println(info);
    }

    public static void main(String[] args) {
        Logger.getDefaultLogger().debug("12222");
    }

    public synchronized void info(Object obj) {
        String info = "[Info] [" + DateUtility.getNow() + "]" + this.getCommonOut() + " - " + obj.toString();
        System.out.println(info);
        try {
            this.judgeSize(info.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.write(info);
    }

    public synchronized void warn(Object obj) {
        String info = "[Warn] [" + DateUtility.getNow() + "]" + this.getCommonOut() + " - " + obj.toString();
        System.out.println(info);
        try {
            this.judgeSize(info.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.write(info);
    }

    private void write(String info) {
        FileIO.write(this.outFile, info + "\r\n", true);
    }

    private void judgeSize(long len) throws FileNotFoundException {
        long length = this.outFile.length();
        if (length + len >= this.file_size) {
            String pureName = FileUtility.getPureName(this.outFile);
            Integer index = StringUtility.extractInteger(pureName);
            if (index == null) {
                index = 1;
            } else {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            String path = this.outFile.getAbsolutePath();
            this.outFile = new File(path.substring(0, path.lastIndexOf("\\") + 1) + "log" + index + ".txt");
            FileUtility.createFile(this.outFile);
            this.redirect();
        }
    }

    public boolean isDebugEnabled() {
        return isDebug;
    }

    public void setDebugEnabled(boolean flag) {
        isDebug = flag;
    }

    private String getCommonOut() {
        return Thread.currentThread().getStackTrace()[2].getClassName() + "." + Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    public static Logger getDefaultLogger() {
        return LazyHolder.logger;
    }

    private static class LazyHolder {
        private static Logger logger = new Logger();

        private LazyHolder() {
        }
    }
}

