/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt.analyse;

import com.mhdt.io.RandomAcessInputStream;
import com.mhdt.toolkit.Reflect;
import com.mhdt.toolkit.StringUtility;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validate {
    public static final Pattern pattern_PHONE = Pattern.compile("1(3[0-9]|45|47|5[012356789]|7[0678]|8[0-9])[0-9]{8}");
    public static final Pattern pattern_TELEPHONE = Pattern.compile("((0\\d{2,3}|852|853)[-\u2014]?[2-8]\\d{6,7}|[2-8]\\d{6,7})");
    private static Pattern pattern_name = Pattern.compile("^([\u4e00-\u9fa5]{2,5}|[a-zA-Z\\.\\s]{1,20})$");
    private static Pattern pattern_url = Pattern.compile("(http://|www.)*[\\w\\.\\-\\_]{2,150}\\.(guide|store|fish|house|party|city|info|vip|help|sexy|camp|fail|pink|video|lol|cool|host|hosting|loan|mom|biz|\u4e2d\u6587\u7f51|tax|hiphop|auto|cheap|xyz|gift|link|click|org|wang|net|space|date|pics|bike|life|wiki|site|limo|flowers|news|green|solar|tech|red|club|tv|ren|design|zone|tm|com|diet|mobi|download|tools|software|cars|care|fund|today|live|shoes|so|watch|pub|ink|co|marke|cn|company|la|cash|town|lawyer|ltd|media|cc|gov|car|trade|land|hk|online|farm|cab|name|asia|guru|rocks|bid|top|poker|audio|website|win|photo|ninja|blue|ac|pro|toys|pw|tips)");

    private Validate() {
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null || obj.toString().equals("null")) {
            return true;
        }
        return obj.toString().replaceAll("\\s", "").replaceAll("[\u00a0]", "").equals("");
    }

    public static boolean isPhone(String phone) {
        if (Validate.isNullOrEmpty(phone)) {
            return false;
        }
        return pattern_PHONE.matcher(phone).matches();
    }

    public static boolean isTelephone(String telephone) {
        if (Validate.isNullOrEmpty(telephone)) {
            return false;
        }
        telephone = telephone.replaceAll("\\s", "").replaceAll("[-\uff0d\u2014]{1,}", "-");
        return pattern_TELEPHONE.matcher(telephone).matches();
    }

    public static boolean isTrueName(String name) {
        if (Validate.isNullOrEmpty(name)) {
            return false;
        }
        return pattern_name.matcher(name).matches();
    }

    public static boolean isUrl(String url) {
        if (Validate.isNullOrEmpty(url)) {
            return false;
        }
        Matcher m = pattern_url.matcher(url);
        return m.find();
    }

    public static boolean isEmail(String email) {
        if (Validate.isNullOrEmpty(email)) {
            return false;
        }
        if (email.startsWith("www.")) {
            return false;
        }
        String regex = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isEnglishOrNum(char ch) {
        if (Validate.isEnglish(ch)) {
            return true;
        }
        return Validate.isNum(ch);
    }

    public static boolean isEnglishOrNum(Object content) {
        if (Validate.isNullOrEmpty(content)) {
            return false;
        }
        String str = content.toString();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Validate.isEnglishOrNum(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnglish(char ch) {
        char val = ch;
        if (val > '@' && val < '[') {
            return true;
        }
        return val > '`' && val < '{';
    }

    public static boolean isEnglish(Object content) {
        if (Validate.isNullOrEmpty(content)) {
            return false;
        }
        String str = content.toString();
        for (int i = 0; i < str.length(); ++i) {
            if (Validate.isEnglish(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNum(char ch) {
        char val = ch;
        return val > '/' && val < ':';
    }

    public static boolean isNum(Object obj) {
        if (Validate.isNullOrEmpty(obj)) {
            return false;
        }
        try {
            Double.parseDouble(obj.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBlank(char c) {
        char val = c;
        return val <= ' ' || val == '\t' || val == '\u00a0' || val == '\u3000';
    }

    public static boolean isChinese(Character ch) {
        if (ch == null) {
            return false;
        }
        return Pattern.compile("[\u4e00-\u9fa5]+").matcher(String.valueOf(ch)).matches();
    }

    public static boolean hasField(Object obj, String fieldName) {
        if (obj == null) {
            return false;
        }
        try {
            Field field = Reflect.getField(obj, fieldName);
            if (field != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean hasField(Class<?> cls, String fieldName) {
        if (cls == null) {
            return false;
        }
        try {
            Field field = Reflect.getField(cls, fieldName);
            if (field != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean hasMethod(Object obj, String methodName, Class ... paramClasses) {
        try {
            obj.getClass().getMethod(methodName, paramClasses);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isLink(String url) {
        if (url.startsWith("www.")) {
            url = "http://" + url;
        }
        url = StringUtility.removeBlankChar(url);
        try {
            URL ur = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)ur.openConnection();
            conn.setConnectTimeout(7000);
            conn.setReadTimeout(5000);
            int code = conn.getResponseCode();
            if (code == 400 || code == 404 || code == 503) {
                return false;
            }
            String text = StringUtility.toString(conn.getInputStream());
            if (Validate.isNullOrEmpty(text)) {
                return false;
            }
            text = text.replaceAll("<script[^>]*>[\\s\\S]*</script>", "").replaceAll("<[^>]+>", " ").trim().replaceAll("[\\s]+", " ");
            System.out.println(text);
            if (text.equals("114") || text.startsWith("Request Rejected The requested URL was rejected")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object[] link(String url) {
        int http_code = -1;
        boolean flag = true;
        int analyse_code = 0;
        String content = "";
        if (url.startsWith("www.")) {
            url = "http://" + url;
        }
        url = StringUtility.removeBlankChar(url);
        try {
            URL ur = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)ur.openConnection();
            conn.setConnectTimeout(7000);
            conn.setReadTimeout(5000);
            http_code = conn.getResponseCode();
            if (http_code == 400 || http_code == 404 || http_code == 503) {
                return new Object[]{false, http_code, -1, content};
            }
            RandomAcessInputStream stream = new RandomAcessInputStream(conn.getInputStream());
            stream.mark(0);
            String text = content = StringUtility.toString(stream);
            if (Validate.isNullOrEmpty(text)) {
                return new Object[]{false, http_code, -2, content};
            }
            String chaset = Validate.getCharset(text);
            System.out.println("chaset--> " + chaset);
            if (!chaset.toLowerCase().equals("utf-8")) {
                stream.reset();
                text = content = StringUtility.toString(stream, chaset);
            }
            text = text.toLowerCase();
            String title = "";
            if (text.indexOf("<title>") != -1 && text.indexOf("</title>") != -1) {
                title = text.substring(text.indexOf("<title>") + "<title>".length(), text.indexOf("</title>"));
            }
            System.out.println("\u6807\u9898-->" + title);
            String body = "";
            text = text.replaceAll("<body[^\\>]+>", "<body>").replaceAll("<title[^\\>]+>", "<title>");
            if (text.indexOf("<body>") != -1 && text.indexOf("</body>") != -1) {
                body = text.substring(text.indexOf("<body>") + "<body>".length(), text.indexOf("</body>"));
            }
            System.out.println("\u6b63\u6587-->" + !Validate.isNullOrEmpty(body));
            if (Validate.isNullOrEmpty(body)) {
                return new Object[]{false, http_code, -2, content};
            }
            text = text.replaceAll("<script[^>]*>[\\s\\S]*</script>", "").replaceAll("<[^>]+>", " ").trim().replaceAll("[\\s]+", " ");
            if (title.startsWith("114") || text.startsWith("Request Rejected The requested URL was rejected")) {
                flag = false;
                analyse_code = -2;
            }
        }
        catch (Exception e) {
            flag = false;
            analyse_code = -1;
        }
        return new Object[]{flag, http_code, analyse_code, content};
    }

    private static String getCharset(String text) {
        if (Validate.isNullOrEmpty(text)) {
            return text;
        }
        String charset = text;
        if (text.indexOf("charset=") != -1) {
            charset = text.substring(text.indexOf("charset=") + "charset=".length());
            Matcher matcher = Pattern.compile("[0-9a-zA-Z]+").matcher(charset);
            if (matcher.find()) {
                charset = matcher.group();
            }
        }
        return charset;
    }

    public static boolean isPerfectMatch(String regex, String input) {
        return Pattern.matches(regex, input);
    }
}

