/*
 * Decompiled with CFR 0.152.
 */
package com.mhdt;

import com.mhdt.toolkit.DateUtility;
import org.fusesource.jansi.Ansi;

public class Print {
    static int lastTime;

    public static void error(Object obj) {
        System.out.println(Print.toString("[Erro]", "RED", obj));
    }

    public static void info(Object obj) {
        System.out.println(Print.toString("[Info]", "CYAN", obj));
    }

    public static void warn(Object obj) {
        System.out.println(Print.toString("[Warn]", "WHITE", obj));
    }

    private static String toString(Object sign, String color, Object obj) {
        return Print.translate(color, sign + " at ") + Print.getCodeInfo(3) + Print.translate("MAGENTA", " - ") + Print.translate(color, obj.toString());
    }

    private static String getTime() {
        if (DateUtility.getNowForInt() - lastTime > 5) {
            lastTime = DateUtility.getNowForInt();
            return DateUtility.getNow();
        }
        return DateUtility.getNow("HH:mm:ss");
    }

    public static String getCodeInfo(Integer i) {
        if (i == null || i < 0) {
            i = 3;
        }
        StackTraceElement ste = new Throwable().getStackTrace()[i];
        return "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
    }

    public static void end() {
        Print.warn("Application end .");
    }

    public static void start() {
        Print.warn("Application start .");
    }

    public static void info(String message, int i) {
        System.out.println(Print.getCodeInfo(i) + message);
    }

    public static String translate(String color, String obj) {
        try {
            Class.forName("org.fusesource.jansi.Ansi");
            return Ansi.ansi().eraseScreen().render("@|" + color + " " + obj.toString() + "|@ ").toString();
        }
        catch (ClassNotFoundException e) {
            return obj.toString();
        }
    }
}

