/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import online.sanen.cdm.template.transaction.Transaction;
import online.sanen.cdm.template.transaction.TransactionException;
import online.sanen.cdm.template.transaction.TransactionIsolationLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(JdbcTransaction.class);
    protected Connection connection;
    protected DataSource dataSource;
    protected TransactionIsolationLevel level;
    protected boolean autoCommmit;

    public JdbcTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit) {
        this.dataSource = ds;
        this.level = desiredLevel;
        this.autoCommmit = desiredAutoCommit;
    }

    public JdbcTransaction(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing JDBC Connection [" + this.connection + "]"));
            }
            this.connection.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rolling back JDBC Connection [" + this.connection + "]"));
            }
            this.connection.rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.resetAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing JDBC Connection [" + this.connection + "]"));
            }
            this.connection.close();
        }
    }

    protected void setDesiredAutoCommit(boolean desiredAutoCommit) {
        try {
            if (this.connection.getAutoCommit() != desiredAutoCommit) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting autocommit to " + desiredAutoCommit + " on JDBC Connection [" + this.connection + "]"));
                }
                this.connection.setAutoCommit(desiredAutoCommit);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Error configuring AutoCommit.  Your driver may not support getAutoCommit() or setAutoCommit(). Requested setting: " + desiredAutoCommit + ".  Cause: " + e, e);
        }
    }

    protected void resetAutoCommit() {
        block4: {
            try {
                if (!this.connection.getAutoCommit()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resetting autocommit to true on JDBC Connection [" + this.connection + "]"));
                    }
                    this.connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Error resetting autocommit to true before closing the connection.  Cause: " + e));
            }
        }
    }

    protected void openConnection() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening JDBC Connection");
        }
        this.connection = this.dataSource.getConnection();
        if (this.level != null) {
            this.connection.setTransactionIsolation(this.level.getLevel());
        }
        this.setDesiredAutoCommit(this.autoCommmit);
    }

    @Override
    public Integer getTimeout() throws SQLException {
        return null;
    }
}

