/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import online.sanen.cdm.template.ResultSetExtractor;
import online.sanen.cdm.template.SqlRowSet;
import online.sanen.cdm.template.SqlRowSetWrapp;

public class ResultSetExtractor2SqlRowSet
implements ResultSetExtractor<SqlRowSet> {
    private static final CachedRowSetFactory cachedRowSetFactory = new StandardCachedRowSetFactory();

    @Override
    public SqlRowSet extractData(ResultSet rs) throws SQLException {
        return this.createSqlRowSet(rs);
    }

    protected SqlRowSet createSqlRowSet(ResultSet rs) throws SQLException {
        CachedRowSet rowSet = this.newCachedRowSet();
        rowSet.populate(rs);
        return new SqlRowSetWrapp(rowSet);
    }

    protected CachedRowSet newCachedRowSet() throws SQLException {
        return cachedRowSetFactory.createCachedRowSet();
    }

    private static class StandardCachedRowSetFactory
    implements CachedRowSetFactory {
        private final RowSetFactory rowSetFactory;

        public StandardCachedRowSetFactory() {
            try {
                this.rowSetFactory = RowSetProvider.newFactory();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Cannot create RowSetFactory through RowSetProvider", ex);
            }
        }

        @Override
        public CachedRowSet createCachedRowSet() throws SQLException {
            return this.rowSetFactory.createCachedRowSet();
        }
    }

    private static interface CachedRowSetFactory {
        public CachedRowSet createCachedRowSet() throws SQLException;
    }
}

