/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.toolkit.Assert;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import online.sanen.cdm.template.ArgumentPreparedStatementSetter;
import online.sanen.cdm.template.BatchUpdateUtils;
import online.sanen.cdm.template.DataAccessException;
import online.sanen.cdm.template.DataAccessUtils;
import online.sanen.cdm.template.DataSourceUtils;
import online.sanen.cdm.template.JdbcOperations;
import online.sanen.cdm.template.JdbcUtils;
import online.sanen.cdm.template.KeyHolder;
import online.sanen.cdm.template.PreparedStatementCallback;
import online.sanen.cdm.template.PreparedStatementCreator;
import online.sanen.cdm.template.PreparedStatementSetter;
import online.sanen.cdm.template.PreparedStatementSetterBatch;
import online.sanen.cdm.template.PreparedStatementSetterBatchCustom;
import online.sanen.cdm.template.ResultSetExtractor;
import online.sanen.cdm.template.ResultSetExtractor2List;
import online.sanen.cdm.template.ResultSetExtractor2SqlRowSet;
import online.sanen.cdm.template.RowExtractor;
import online.sanen.cdm.template.RowExtractor2Entry;
import online.sanen.cdm.template.RowExtractor2Map;
import online.sanen.cdm.template.RowExtractor2SingleColumn;
import online.sanen.cdm.template.SqlProvider;
import online.sanen.cdm.template.SqlRowSet;
import online.sanen.cdm.template.StatementCallback;
import online.sanen.cdm.template.TransactionManager;
import online.sanen.cdm.template.transaction.Transaction;
import online.sanen.cdm.template.transaction.TransactionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcTemplate
implements JdbcOperations {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    boolean isOpenSession;
    Transaction transaction;
    boolean isAutoCommit = true;

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int update(String sql, Object ... args) {
        return this.update(sql, this.newArgPreparedStatementSetter(args));
    }

    @Override
    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return this.update((PreparedStatementCreator)new SimplePreparedStatementCreator(sql), pss);
    }

    protected int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug((Object)"Executing prepared SQL update");
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                if (pss != null) {
                    pss.setValues(ps);
                }
                int rows = ps.executeUpdate();
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + rows + " rows"));
                }
                return rows;
            }
        });
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql) {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) {
        return this.query(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForEntries(String sql, Class<T> entryType, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getEntryRowMapper(entryType));
    }

    private <T> RowExtractor<T> getEntryRowMapper(Class<T> entryType) {
        return new RowExtractor2Entry<T>(entryType);
    }

    protected <T> RowExtractor<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new RowExtractor2SingleColumn<T>(requiredType);
    }

    protected RowExtractor<Map<String, Object>> getColumnMapRowMapper() {
        return new RowExtractor2Map();
    }

    @Override
    public Map<String, Object> queryForMap(String sql) {
        return this.queryForObject(sql, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) {
        return this.queryForObject(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(String sql, RowExtractor<T> rowMapper) {
        List<T> results = this.query(sql, rowMapper);
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForEntry(String sql, Class<T> entryType, Object ... args) throws DataAccessException {
        List<T> results = this.query(sql, this.getEntryRowMapper(entryType));
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, args, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, RowExtractor<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, new ResultSetExtractor2List<T>(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Override
    public <T> List<T> query(String sql, RowExtractor<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, new ResultSetExtractor2List<T>(rowMapper));
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull(rse, (String)"ResultSetExtractor must not be null");
        this.logger.debug((Object)"Executing prepared SQL query");
        return this.execute(psc, new PreparedStatementCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Object t;
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    rs = ps.executeQuery();
                    t = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return t;
            }
        });
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, RowExtractor<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, args, new ResultSetExtractor2List<T>(rowMapper));
    }

    @Override
    public <T> T query(final String sql, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        Assert.notNull(rse, (String)"ResultSetExtractor must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL query [" + sql + "]"));
        }
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInStatement(Statement stmt) throws SQLException {
                Object t;
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery(sql);
                    t = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return t;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
        return new ArgumentPreparedStatementSetter(args);
    }

    @Override
    public <T> T execute(StatementCallback<T> action) throws DataAccessException {
        T t;
        Assert.notNull(action, (String)"Callback object must not be null");
        Connection con = null;
        Statement stmt = null;
        try {
            T result;
            con = DataSourceUtils.getConnection(this.getTransAction(), this.getDataSource());
            stmt = con.createStatement();
            this.applyStatementSettings(stmt);
            t = result = action.doInStatement(stmt);
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                DataSourceUtils.releaseConnection(this.getTransAction(), con);
                con = null;
                throw new DataAccessException("StatementCallback:" + JdbcTemplate.getSql(action), ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(this.getTransAction(), con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        DataSourceUtils.releaseConnection(this.getTransAction(), con);
        return t;
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize != -1) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) != -1) {
            stmt.setMaxRows(maxRows);
        }
        DataSourceUtils.applyTimeout(stmt, this.getDataSource(), this.getQueryTimeout());
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int[] batchUpdate(String sql, final PreparedStatementSetterBatch pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update [" + sql + "]"));
        }
        return this.execute(sql, new PreparedStatementCallback<int[]>(){

            @Override
            public int[] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int batchSize = pss.getBatchSize();
                if (JdbcUtils.supportsBatchUpdates(ps.getConnection())) {
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        ps.addBatch();
                    }
                    return ps.executeBatch();
                }
                ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                for (int i = 0; i < batchSize; ++i) {
                    pss.setValues(ps, i);
                    rowsAffected.add(ps.executeUpdate());
                }
                int[] rowsAffectedArray = new int[rowsAffected.size()];
                for (int i = 0; i < rowsAffectedArray.length; ++i) {
                    rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                }
                return rowsAffectedArray;
            }
        });
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws DataAccessException {
        return BatchUpdateUtils.executeBatchUpdate(sql, batchArgs, this);
    }

    @Override
    public <T> int[][] batchUpdate(String sql, final Collection<T> batchArgs, final int batchSize, final PreparedStatementSetterBatchCustom<T> pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update [" + sql + "] with a batch size of " + batchSize));
        }
        return this.execute(sql, new PreparedStatementCallback<int[][]>(){

            @Override
            public int[][] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                ArrayList<int[]> rowsAffected = new ArrayList<int[]>();
                boolean batchSupported = true;
                if (!JdbcUtils.supportsBatchUpdates(ps.getConnection())) {
                    batchSupported = false;
                    JdbcTemplate.this.logger.warn((Object)"JDBC Driver does not support Batch updates; resorting to single statement execution");
                }
                int n = 0;
                for (Object obj : batchArgs) {
                    pss.setValues(ps, obj);
                    ++n;
                    if (batchSupported) {
                        ps.addBatch();
                        if (n % batchSize != 0 && n != batchArgs.size()) continue;
                        if (JdbcTemplate.this.logger.isDebugEnabled()) {
                            int batchIdx = n % batchSize == 0 ? n / batchSize : n / batchSize + 1;
                            int items = n - (n % batchSize == 0 ? n / batchSize - 1 : n / batchSize) * batchSize;
                            JdbcTemplate.this.logger.debug((Object)("Sending SQL batch update #" + batchIdx + " with " + items + " items"));
                        }
                        rowsAffected.add(ps.executeBatch());
                        continue;
                    }
                    int i = ps.executeUpdate();
                    rowsAffected.add(new int[]{i});
                }
                int[][] result = new int[rowsAffected.size()][];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (int[])rowsAffected.get(i);
                }
                return result;
            }
        });
    }

    @Override
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws DataAccessException {
        T t;
        Assert.notNull((Object)psc, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql = JdbcTemplate.getSql(psc);
            this.logger.debug((Object)("Executing prepared SQL statement" + (sql != null ? " [" + sql + "]" : "")));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            T result;
            Connection conToUse = con = DataSourceUtils.getConnection(this.getTransAction(), this.getDataSource());
            ps = psc.createPreparedStatement(conToUse);
            this.applyStatementSettings(ps);
            PreparedStatement psToUse = ps;
            t = result = action.doInPreparedStatement(psToUse);
        }
        catch (SQLException ex) {
            try {
                String sql = JdbcTemplate.getSql(psc);
                psc = null;
                JdbcUtils.closeStatement(ps);
                ps = null;
                DataSourceUtils.releaseConnection(this.getTransAction(), con);
                con = null;
                throw new DataAccessException("PreparedStatementCallback " + sql, ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(this.getTransAction(), con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(this.getTransAction(), con);
        return t;
    }

    @Override
    public SqlRowSet queryForRowSet(String sql, Object ... args) throws DataAccessException {
        return this.query(sql, args, new ResultSetExtractor2SqlRowSet());
    }

    @Override
    public void execute(final String sql) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
        }
        class ExecuteStatementCallback
        implements StatementCallback<Object>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(sql);
                return null;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback());
    }

    @Override
    public int update(PreparedStatementCreator psc, final KeyHolder generatedKeyHolder) throws DataAccessException {
        Assert.notNull((Object)generatedKeyHolder, (String)"KeyHolder must not be null");
        this.logger.debug((Object)"Executing SQL update and returning generated keys");
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int rows = ps.executeUpdate();
                List<Map<String, Object>> generatedKeys = generatedKeyHolder.getKeyList();
                generatedKeys.clear();
                ResultSet keys = ps.getGeneratedKeys();
                if (keys != null) {
                    try {
                        ResultSetExtractor2List<Map<String, Object>> rse = new ResultSetExtractor2List<Map<String, Object>>(JdbcTemplate.this.getColumnMapRowMapper(), 1);
                        generatedKeys.addAll((Collection<Map<String, Object>>)rse.extractData(keys));
                    }
                    finally {
                        JdbcUtils.closeResultSet(keys);
                    }
                }
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + rows + " rows and returned " + generatedKeys.size() + " keys"));
                }
                return rows;
            }
        });
    }

    public void bindTransaction(TransactionFactory factory) {
        TransactionManager.bindTransactionFatory(factory);
    }

    public void openSession(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
        TransactionManager.getTransaction(this.dataSource, null, this.isAutoCommit);
    }

    public void commit() throws SQLException {
        Transaction transaction = TransactionManager.getTransaction(this.dataSource, null, this.isAutoCommit);
        Assert.notNull((Object)transaction, (String)"transaction is null");
        transaction.commit();
        TransactionManager.closeSqlTransaction();
        this.isAutoCommit = true;
    }

    public void rollback() throws SQLException {
        Transaction transaction = TransactionManager.getTransaction(this.dataSource, null, this.isAutoCommit);
        Assert.notNull((Object)transaction, (String)"transaction is null");
        transaction.rollback();
        TransactionManager.closeSqlTransaction();
        this.isAutoCommit = true;
    }

    private Transaction getTransAction() {
        return TransactionManager.getTransaction(this.dataSource, null, this.isAutoCommit) == null ? this.transaction : TransactionManager.getTransaction(this.dataSource, null, this.isAutoCommit);
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            Assert.notNull((Object)sql, (String)"SQL must not be null");
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }
}

