/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.toolkit.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import online.sanen.cdm.template.transaction.JdbcTransaction;
import online.sanen.cdm.template.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceUtils {
    private static final Log logger = LogFactory.getLog(DataSourceUtils.class);

    public static Connection getConnection(Transaction transaction, DataSource dataSource) throws SQLException {
        if (transaction != null) {
            return transaction.getConnection();
        }
        return DataSourceUtils.fetchConnection(dataSource);
    }

    private static Connection fetchConnection(DataSource dataSource) throws SQLException {
        Connection con = dataSource.getConnection();
        if (con == null) {
            throw new IllegalStateException("DataSource returned null from getConnection(): " + dataSource);
        }
        return con;
    }

    public static void releaseConnection(Transaction transaction, Connection con) {
        if (transaction != null) {
            if (!(transaction instanceof JdbcTransaction)) {
                try {
                    transaction.close();
                }
                catch (SQLException e) {
                    logger.debug((Object)"Could not close JDBC Connection", (Throwable)e);
                }
            }
        } else {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC Connection", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC Connection", ex);
            }
        }
    }

    public static void applyTimeout(Statement stmt, DataSource dataSource, int queryTimeout) throws SQLException {
        Assert.notNull((Object)stmt, (String)"No Statement specified");
        if (queryTimeout >= 0) {
            stmt.setQueryTimeout(queryTimeout);
        }
    }
}

