package online.sanen.cdm.template;

import java.util.Collection;

import com.mhdt.analyse.Validate;

/**
 * 
 * <pre>
 *
 * &#64;author online.sanen
 * Date:2018年10月14日
 * Time:下午6:28:59
 * </pre>
 */
public class DataAccessUtils {

	public static <T> T requiredSingleResult(Collection<T> results) throws DataAccessException {
		
		if (Validate.isNullOrEmpty(results)) {
			throw new DataAccessException("You have to have at least one result, which is actually 0");
		}
		if (results.size() > 1) {
			throw new DataAccessException(
					"The number of results should be 1, but the actual number is " + results.size());
		}
		return results.iterator().next();
	}

}
