/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.degist.Validate;
import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import online.sanen.cdm.template.JdbcOperations;
import online.sanen.cdm.template.PreparedStatementSetterBatch;

public abstract class BatchUpdateUtils {
    public static int[] executeBatchUpdate(String sql, final List<Object[]> batchValues, JdbcOperations jdbcOperations) {
        return jdbcOperations.batchUpdate(sql, new PreparedStatementSetterBatch(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = (Object[])batchValues.get(i);
                BatchUpdateUtils.setStatementParameters(values, ps);
            }

            @Override
            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    protected static void setStatementParameters(Object[] values, PreparedStatement ps) throws SQLException {
        int colIndex = 0;
        for (Object value : values) {
            ++colIndex;
            try {
                if (Validate.isEnum((Object)value)) {
                    ps.setString(colIndex, String.valueOf(value));
                    continue;
                }
                Method method = Reflect.getMethod((Object)ps, (String)("set" + value.getClass().getSimpleName()), (Class[])new Class[]{Integer.TYPE, value.getClass()});
                method.invoke((Object)ps, colIndex, value);
            }
            catch (Exception e) {
                ps.setObject(colIndex, value);
            }
        }
    }
}

