/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template.jpa;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Reflect;
import com.mhdt.toolkit.ReflectionException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import online.sanen.cdm.template.jpa.BootStrapID;
import online.sanen.cdm.template.jpa.Column;
import online.sanen.cdm.template.jpa.Id;
import online.sanen.cdm.template.jpa.NoDB;
import online.sanen.cdm.template.jpa.Priority;
import online.sanen.cdm.template.jpa.Table;

public class JPA {
    static Map<String, Field> alias = new HashMap<String, Field>();
    static Map<Class<?>, String> bootstrapIdCache = new HashMap();
    static Map<Class<?>, Primarykey> idCache = new HashMap();

    public static Field getFieldByAlias(Object obj, String column) {
        Field[] fields;
        String key = obj.getClass().getName() + "$" + column;
        if (alias.containsKey(key)) {
            return alias.get(key);
        }
        for (Field f : fields = Reflect.getFields((Object)obj)) {
            if (!f.isAnnotationPresent(Column.class) || !f.getAnnotation(Column.class).name().equals(column)) continue;
            f.setAccessible(true);
            alias.put(key, f);
            return f;
        }
        return null;
    }

    public static String getBootStrapId(Class<?> cls) {
        if (bootstrapIdCache.containsKey(cls)) {
            return bootstrapIdCache.get(cls);
        }
        if ((cls = Reflect.getClassOfHasAnnotation(cls, BootStrapID.class)) == null) {
            return null;
        }
        String result = cls.getAnnotation(BootStrapID.class).value();
        if (!Validate.isNullOrEmpty((Object)result)) {
            bootstrapIdCache.put(cls, result);
        }
        return result;
    }

    public static String getTableName(Class<?> cls) {
        return (cls = Reflect.getClassOfHasAnnotation(cls, Table.class)) == null ? null : cls.getAnnotation(Table.class).name();
    }

    public static Primarykey getId(Class<?> entryClass) {
        if (idCache.containsKey(entryClass)) {
            return idCache.get(entryClass);
        }
        Field field = Reflect.getFieldOfHasAnnotation(entryClass, Id.class);
        if (field == null) {
            throw new RuntimeException("The id annotation cannot be found in the class\uff1a" + entryClass);
        }
        Primarykey primarykey = new Primarykey(field);
        idCache.put(entryClass, primarykey);
        return primarykey;
    }

    public static Map<String, Class<?>> structured(Object obj) {
        Field[] fileds;
        HashMap map = new HashMap();
        for (Field field : fileds = Reflect.getFields((Object)obj)) {
            if (Validate.isStatic((Field)field) || field.isAnnotationPresent(NoDB.class)) continue;
            field.setAccessible(true);
            map.put(field.getName(), field.getType().isEnum() ? String.class : field.getType());
        }
        return map;
    }

    public static Object getInject(Object target, String field) {
        Field f = Reflect.getField((Object)target, (String)field);
        f = f == null ? JPA.getFieldByAlias(target, field) : f;
        return Reflect.getInject((Object)target, (String)f.getName());
    }

    public static void setInject(Object target, String columnName, Object value) {
        Field f = Reflect.getField((Object)target, (String)columnName);
        f = f == null ? JPA.getFieldByAlias(target, columnName) : f;
        try {
            if (f.isAnnotationPresent(NoDB.class)) {
                return;
            }
        }
        catch (NullPointerException e) {
            if (target.getClass().isAnnotationPresent(Priority.class)) {
                return;
            }
            throw new ReflectionException("Cant match field for '" + columnName + "' from " + target.getClass(), (Throwable)e);
        }
        Reflect.setInject((Object)target, (String)f.getName(), (Object)value);
    }

    public static class Primarykey {
        String name;
        Object value;
        Field field;

        public Primarykey(Field field) {
            this.field = field;
            this.name = field.isAnnotationPresent(Column.class) && !Validate.isNullOrEmpty((Object)field.getAnnotation(Column.class).name()) ? field.getAnnotation(Column.class).name() : field.getName();
        }

        public Primarykey(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue(Object target) {
            return Reflect.getInject((Object)target, (Field)this.field);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

